<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(PolicyCxBlockDao dao){
	PolicyCxBlockData data = new PolicyCxBlockData();
	data.enableFilter = paramBoolean("enableFilter");
	data.blockIpHost = paramBoolean("blockIpHost");
	data.blockedKeyword = paramString("blockedKeyword");
	data.cacheTtl = paramInt("cacheTtl");

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
PolicyCxBlockDao dao = new PolicyCxBlockDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
PolicyCxBlockData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<fieldset>
	<legend>CXBLOCK</legend>
<table class="view">

	<tr>
		<td width="200">Enable Filter</td>
		<td>
		<input type="checkbox" class="no-border" name="enableFilter"
			<%if(data.enableFilter){out.print("checked");}%>> CxBlock is a remote filtering agent for Chromebook.
			</td>
	</tr>

	<tr>
		<td>Block IP host</td>
		<td><input type="checkbox" class="no-border" name="blockIpHost"
			<%if(data.blockIpHost){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Query Cache TTL</td>
		<td><input type="text" name="cacheTtl" value="<%= data.cacheTtl%>" size="2"> seconds, 60 ~ 3600</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>
<!-- /view -->

<%@include file="include/footer.jsp"%>
