<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(AccessControlDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	AccessControlData data = new AccessControlData();
	data.dnsAllowed = paramString("dnsAllowed");
	data.dnsBlocked = paramString("dnsBlocked");
	data.bypassAll = paramString("bypassAll");

	String invalidIp = ParamTest.findInvalidAllowedIp(data.dnsAllowed);
	if(isEmpty(invalidIp)){
		invalidIp = ParamTest.findInvalidAllowedIp(data.dnsBlocked);
	}
	if(isEmpty(invalidIp)){
		invalidIp = ParamTest.findInvalidAllowedIp(data.bypassAll);
	}

	if(isNotEmpty(invalidIp)){
		if(invalidIp.contains("/")){
			errList.add("Invalid CIDR - " + invalidIp);
			return;
		}

		if(invalidIp.contains("-")){
			errList.add("Invalid IP range - " + invalidIp);
			return;
		}

		errList.add("Invalid IP - " + invalidIp);
		return;
	}

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
AccessControlDao dao = new AccessControlDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
AccessControlData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<fieldset>
<legend>ACCESS CONTROL</legend>
<table width="100%" class="view">

	<tr>
		<td colspan="2">
			<div style="line-height:20px;">
				This is an IP based access control. You can add IP addresses, IP ranges, CIDRs separated by spaces or newlines.
			</div>
				<div class="tab">
					ex) 192.168.0.10 192.168.0.20<br>
					192.168.0.21-192.168.0.100<br>
					192.168.1.0/24
				</div>
		</td>
	</tr>

	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>

	<tr>
		<td width="220" valign="top">
			Allowed IP for DNS
			<i class="fa fa-question-circle south-east" title="Whitelist based access control. You can accept DNS queries from specific IPs only.<br>
				If there's nothing added here everybody can access your DNS."></i>
		</td>
		<td>
			<textarea name="dnsAllowed" cols="80" rows="10"><%= data.dnsAllowed%></textarea>
		</td>
	</tr>

	<tr>
		<td valign="top">
			Blocked IP for DNS
			<i class="fa fa-question-circle south-east" title="Blacklist based access control.<br>
				It overrides 'Allowed IP for DNS'."></i>
		</td>
		<td>
			<textarea name="dnsBlocked" cols="80" rows="10"><%= data.dnsBlocked%></textarea>
		</td>
	</tr>

	<tr>
		<td valign="top">
			Bypass All
			<i class="fa fa-question-circle south-east" title="Bypass from authentication and filtering, logging."></i>
		</td>
		<td>
			<textarea name="bypassAll" cols="80" rows="10"><%= data.bypassAll%></textarea>
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>
<!-- /view -->

<%@include file="include/footer.jsp"%>
