<%@include file="include/lib.jsp"%>
<%
//-----------------------------------------------
// Create data access object.
UserLoginDao dao = new UserLoginDao(request);
boolean failFlag = false;
boolean cntFlag = false;

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("logout")){
	dao.logout();
}
if(actionFlag.equals("login")){
	String uname = paramString("uname");
	String passwd = paramString("passwd");

	if(dao.hasActiveLoginSession(uname)){
		dao.logInfo("block,welcome.jsp, We aready have an active login session for {}.", uname);
		response.sendRedirect("block,welcome.jsp");
		return;
	}

	int cnt = dao.countLoginSession(uname);
	int webLoginLimit = dao.getWebLoginLimit();
	if(webLoginLimit > 0 && cnt >= webLoginLimit){
		dao.logInfo("block,welcome.jsp, Too many login session for {}, cnt = {}.", uname, cnt);
		cntFlag = true;
	}
	else{
		if(dao.login(uname, passwd)){
			// If it's by mass imported user with default password
			// and the password hasn't been changed yet.
			// And there's 'block,password.jsp existing'.
			if(dao.needPwchg(uname)){
				// Send it to password change page.
				response.sendRedirect("block,password.jsp");
				return;
			}

			// Send it to welcome page.
			response.sendRedirect("block,welcome.jsp");
			return;
		}
		else{
			//errList.add(translate("Login failed."));
			failFlag = true;
		}
	}
}

// Get login-page.
BlockPageDao bpDao = new BlockPageDao();
BlockPageData data = bpDao.selectOneLocal();
String loginPage = data.loginPage;

// Replace params.
loginPage = loginPage.replaceAll("#\\{nx_name\\}", getNxName());
loginPage = loginPage.replaceAll("#\\{fail_flag\\}", String.valueOf(failFlag));
loginPage = loginPage.replaceAll("#\\{cnt_flag\\}", String.valueOf(cntFlag));

out.print(loginPage);
%>
