/*
 * Decompiled with CFR 0.152.
 */
package nettrack.net.netflow;

import java.net.InetAddress;
import java.util.Map;
import nettrack.net.netflow.FlowHandler;
import nettrack.net.netflow.FlowHeader;
import nettrack.net.netflow.V5Flow;
import nettrack.net.netflow.V5FlowHeader;

public class V5FlowHandler
extends FlowHandler {
    private long nextFlow = -1L;
    private long missedFlows = 0L;
    private long aheadTimes = 0L;

    public V5FlowHandler(InetAddress source, int fifosize) {
        super(source, fifosize);
        this.header = new V5FlowHeader();
        this.flow = new V5Flow();
    }

    public int getVersion() {
        return 5;
    }

    public int getHeaderSize() {
        return 24;
    }

    public int getFlowSize() {
        return 48;
    }

    public int getMaxFlowsPerPacket() {
        return 30;
    }

    public Map getStatistics() {
        Map statistics = super.getStatistics();
        statistics.put("missed flows", new Long(this.missedFlows));
        statistics.put("number of times ahead", new Long(this.aheadTimes));
        return statistics;
    }

    public boolean checkHeader(FlowHeader header) {
        long flowNumber = ((V5FlowHeader)header).getFlowSequence();
        if (this.nextFlow != -1L && this.nextFlow != flowNumber) {
            if (flowNumber > this.nextFlow) {
                this.missedFlows += flowNumber - this.nextFlow;
            } else {
                ++this.aheadTimes;
            }
        }
        this.nextFlow = flowNumber + (long)header.getCount();
        return true;
    }

    public String toString() {
        return "Version 5 NetFlow Handler, listening to flows from " + this.getSource();
    }
}

