/*
 * Decompiled with CFR 0.152.
 */
package nettrack.log;

import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import nettrack.log.Log;
import nettrack.log.Logger;

public class SyslogLogger
implements Logger {
    private InetAddress destAddr;
    private String identity = "Java";
    private int facility = 128;
    private DatagramSocket socket;
    private DatagramPacket packet;
    private static final int PACKET_SIZE = 1024;
    static /* synthetic */ Class class$nettrack$log$SyslogLogger;

    public SyslogLogger(InetAddress dest) throws SocketException {
        this.destAddr = dest;
        this.socket = new DatagramSocket();
        this.packet = new DatagramPacket(new byte[1024], 1024);
    }

    public SyslogLogger(InetAddress dest, String id, int fac) throws SocketException {
        this(dest);
        this.identity = id;
        this.facility = fac;
    }

    public synchronized void log(int severity, Object o) {
        try {
            byte[] data = this.packet.getData();
            int dataLength = 0;
            byte[] pri = ("<" + (this.facility + severity) + ">").getBytes();
            int i = 0;
            while (i < pri.length && dataLength < 1024) {
                data[dataLength++] = pri[i++];
            }
            byte[] id = (this.identity + "[" + Thread.currentThread().getName() + "]: ").getBytes();
            i = 0;
            while (i < id.length && dataLength < 1024) {
                data[dataLength++] = id[i++];
            }
            byte[] message = o.toString().getBytes();
            i = 0;
            while (i < message.length && dataLength < 1024) {
                data[dataLength++] = message[i++];
            }
            this.packet.setLength(dataLength);
            this.packet.setAddress(this.destAddr);
            this.packet.setPort(514);
            this.socket.send(this.packet);
        }
        catch (IOException e) {
            e.printStackTrace(new PrintStream(System.err));
        }
    }

    public static void main(String[] arg) throws Exception {
        if (arg.length != 2) {
            System.err.println("Usage: java " + (class$nettrack$log$SyslogLogger == null ? (class$nettrack$log$SyslogLogger = SyslogLogger.class$("nettrack.log.SyslogLogger")) : class$nettrack$log$SyslogLogger).getName() + " <host> <message>");
            System.exit(1);
        }
        InetAddress host = InetAddress.getByName(arg[0]);
        String message = arg[1];
        Log.setLogger(new SyslogLogger(host));
        Log.info(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

