/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.WhitelistData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.f;
import nxd.o.q;
import nxd.p;

public class WhitelistDomainDao
extends FirstDao {
    public void addKw(String string) {
        if (this.searchOption.size() > 0) {
            return;
        }
        this.searchOption.addKw("domain", string, 2);
        this.searchOption.addKw("description", string, 2);
    }

    private String a() {
        String string = this.searchOption.toSql(12);
        if (nxd.lib.c.a(string)) {
            return " where system_flag = 'FALSE'";
        }
        return " where system_flag = 'FALSE' and (" + string + ")";
    }

    public int selectCount() {
        String string = this.a();
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from whitelist" + string);
        b2.close();
        return n2;
    }

    private boolean a(int n2) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from whitelist where id = ? and system_flag = 'TRUE'", new Object[]{n2});
        b2.close();
        return n3 > 0;
    }

    public boolean delete(int n2) {
        if (this.a(n2)) {
            this.d.error("WDDd, You can't delete a system data!");
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "delete from whitelist where id = ?";
        boolean bl = b2.d(string, new Object[]{n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        if (!DaoUtil.deleteOrphan()) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("whitelist");
        return true;
    }

    public WhitelistData fillData(RowSet rowSet) {
        WhitelistData whitelistData = new WhitelistData();
        whitelistData.id = rowSet.getInt("id");
        whitelistData.domain = rowSet.getString("domain");
        whitelistData.description = rowSet.getString("description");
        whitelistData.bypassAuth = nxd.lib.c.c((Object)rowSet.getString("bypass_auth"));
        whitelistData.bypassFilter = nxd.lib.c.c((Object)rowSet.getString("bypass_filter"));
        whitelistData.bypassLog = nxd.lib.c.c((Object)rowSet.getString("bypass_log"));
        whitelistData.adminBlock = nxd.lib.c.c((Object)rowSet.getString("admin_block"));
        whitelistData.dropPacket = nxd.lib.c.c((Object)rowSet.getString("drop_packet"));
        whitelistData.appliedPolicyMap = DaoUtil.getAppliedPolicyMap(whitelistData.id, false);
        return whitelistData;
    }

    public List<WhitelistData> selectList() {
        String string = this.a();
        int n2 = nxd.lib.c.a(this.limit, this.page);
        ArrayList<WhitelistData> arrayList = new ArrayList<WhitelistData>();
        String string2 = "select * from whitelist" + string;
        string2 = string2 + String.format(" order by lower(domain), id limit %s, %s", n2, this.limit);
        try (b b2 = DaoUtil.getDbConfig();
             RowSet rowSet = b2.l(string2);){
            while (rowSet.next()) {
                arrayList.add(this.fillData(rowSet));
            }
        }
        return arrayList;
    }

    private boolean a(WhitelistData whitelistData) {
        if (!f.f(whitelistData.domain)) {
            this.d.error("WhitelistDomainDao.checkParam, Invalid domain!");
            return false;
        }
        if (ParamTest.isDupWhitelistDomain(whitelistData.domain)) {
            this.d.error("WhitelistDomainDao, Duplicated domain!");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean insert(WhitelistData whitelistData) {
        whitelistData.sanitize();
        if (!this.a(whitelistData)) {
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "select count(*) from whitelist";
            int n2 = b2.f(string);
            if (n2 > 100000) {
                this.d.info("WhitelistDomainDao.insert, Too many domains, cnt = {}.", (Object)n2);
                boolean bl = false;
                return bl;
            }
            string = "insert into whitelist(domain, description, bypass_auth, bypass_filter, bypass_log, admin_block, drop_packet) values(?, ?, ?, ?, ?, ?, ?)";
            b2.b(string, new Object[]{whitelistData.domain, whitelistData.description, nxd.lib.c.d(whitelistData.bypassAuth), nxd.lib.c.d(whitelistData.bypassFilter), nxd.lib.c.d(whitelistData.bypassLog), nxd.lib.c.d(whitelistData.adminBlock), nxd.lib.c.d(whitelistData.dropPacket)});
            WhitelistData whitelistData2 = this.selectOneByDomain(whitelistData.domain);
            if (whitelistData.appliedPolicyArr != null && whitelistData2 != null) {
                for (String string2 : whitelistData.appliedPolicyArr) {
                    string = "insert into wh_policy(wh_id, policy_id) values(?, ?)";
                    b2.b(string, new Object[]{whitelistData2.id, string2});
                }
            }
        }
        catch (Exception exception) {
            this.d.error("WhitelistDomainDao.insert, " + exception.toString());
        }
        if (!DaoUtil.deleteOrphan()) {
            this.d.error("WhitelistDomainDao.insert, DB error!");
            return false;
        }
        this.c.b("whitelist");
        return true;
    }

    private WhitelistData a(String string, Object[] objectArray) {
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.m(string, objectArray);
        if (rowSet == null) {
            b2.close();
            return null;
        }
        WhitelistData whitelistData = this.fillData(rowSet);
        rowSet.close();
        b2.close();
        return whitelistData;
    }

    public WhitelistData selectOne(int n2) {
        String string = "select * from whitelist where id = ?";
        return this.a(string, new Object[]{n2});
    }

    public WhitelistData selectOneByDomain(String string) {
        String string2 = "select * from whitelist where domain = ?";
        return this.a(string2, new Object[]{string});
    }

    public boolean hasDomainAlready(String string) {
        return null != this.selectOneByDomain(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(WhitelistData whitelistData) {
        whitelistData.sanitize();
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "update whitelist set description = ?, bypass_auth = ?, bypass_filter = ?, bypass_log = ?, admin_block = ?, drop_packet = ? where id = ?";
            b2.c(string, new Object[]{whitelistData.description, nxd.lib.c.d(whitelistData.bypassAuth), nxd.lib.c.d(whitelistData.bypassFilter), nxd.lib.c.d(whitelistData.bypassLog), nxd.lib.c.d(whitelistData.adminBlock), nxd.lib.c.d(whitelistData.dropPacket), whitelistData.id});
            string = "delete from wh_policy where wh_id = ?";
            b2.c(string, new Object[]{whitelistData.id});
            if (whitelistData.appliedPolicyArr != null) {
                for (String string2 : whitelistData.appliedPolicyArr) {
                    string = "insert into wh_policy(wh_id, policy_id) values(?, ?)";
                    b2.c(string, new Object[]{whitelistData.id, string2});
                }
            }
        }
        this.c.b("whitelist");
        return true;
    }

    public boolean writeCsvFile(String string) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(new Object[]{"Domain", "Description", "Bypass-Auth", "Bypass-Filter", "Bypass-Log", "Adming Block", "Drop Packet", "Applied Policies"});
        List<WhitelistData> list = this.selectList();
        for (WhitelistData whitelistData : list) {
            Object[] objectArray = new Object[9];
            objectArray[0] = whitelistData.domain;
            objectArray[1] = whitelistData.description;
            objectArray[2] = nxd.lib.c.d(whitelistData.bypassAuth);
            objectArray[3] = nxd.lib.c.d(whitelistData.bypassFilter);
            objectArray[4] = nxd.lib.c.d(whitelistData.bypassLog);
            objectArray[5] = nxd.lib.c.d(whitelistData.adminBlock);
            objectArray[6] = nxd.lib.c.d(whitelistData.dropPacket);
            objectArray[7] = whitelistData.appliedPolicyMap.keySet().stream().map(String::valueOf).collect(Collectors.joining(","));
            arrayList.add(objectArray);
        }
        return q.a(p.m + "/" + string, arrayList);
    }

    public int importFile(String string) {
        int n2 = 0;
        List<Object[]> list = null;
        try {
            list = q.b(string);
        }
        catch (Exception exception) {
            this.d.info("WhitelistDomainDao.importFile, {}", (Object)exception.toString());
        }
        if (list == null) {
            return n2;
        }
        for (Object[] objectArray : list) {
            WhitelistData whitelistData = new WhitelistData();
            whitelistData.domain = objectArray[0].toString();
            whitelistData.description = objectArray[1].toString();
            whitelistData.bypassAuth = nxd.lib.c.c(objectArray[2]);
            whitelistData.bypassFilter = nxd.lib.c.c(objectArray[3]);
            whitelistData.bypassLog = nxd.lib.c.c(objectArray[4]);
            whitelistData.adminBlock = nxd.lib.c.c(objectArray[5]);
            whitelistData.dropPacket = nxd.lib.c.c(objectArray[6]);
            whitelistData.appliedPolicyArr = objectArray[7].toString().split(",");
            if (!this.insert(whitelistData)) continue;
            ++n2;
        }
        if (n2 > 0) {
            this.d.info("WhitelistDomainDao.importFile, Added data = {}", (Object)n2);
        }
        return n2;
    }
}

