/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import nxd.dao.ClusterDao;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.AdminData;
import nxd.lib.RowSet;
import nxd.lib.b;
import org.apache.commons.codec.digest.DigestUtils;

public class AdminDao
extends FirstDao {
    public AdminData selectOne() {
        AdminData adminData = new AdminData();
        String string = "select * from admin";
        boolean bl = new ClusterDao().isSlave();
        if (bl) {
            try (b b2 = DaoUtil.getDbLocal();
                 RowSet rowSet = b2.m(string);){
                adminData.name = rowSet.getString("name");
                adminData.adminPw = rowSet.getString("admin_pw");
            }
            catch (Exception exception) {
                this.d.error("AdminDao.selectOne, " + exception.toString());
            }
        } else {
            try (b b3 = DaoUtil.getDbConfig();
                 RowSet rowSet = b3.m(string);){
                adminData.name = rowSet.getString("name");
                adminData.adminPw = rowSet.getString("admin_pw");
                adminData.clientPw = rowSet.getString("client_pw");
                adminData.reportPw = rowSet.getString("report_pw");
            }
            catch (Exception exception) {
                this.d.error("AdminDao.selectOne, " + exception.toString());
            }
        }
        return adminData;
    }

    private boolean a(AdminData adminData) {
        if (!ParamTest.isValidNameLen(adminData.name)) {
            this.d.error("Admin.checkParam, {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidNameChar(adminData.name)) {
            this.d.error("Admin.checkParam, {}", (Object)"Only alphabet, number, [-_] allowed in name.");
            return false;
        }
        return true;
    }

    private boolean a(String string) {
        if (!ParamTest.isValidPasswdLen(string)) {
            this.d.error("Admin.checkPasswd, {}", (Object)ParamTest.ERR_PASSWD_LEN);
            return false;
        }
        if (!ParamTest.isValidPasswdChar(string)) {
            this.d.error("Admin.checkPasswd, {}", (Object)"Only ASCII character allowed in password.");
            return false;
        }
        return true;
    }

    public boolean update(AdminData adminData) {
        adminData.sanitize();
        if (!this.a(adminData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "update admin set name = ?";
        boolean bl = b2.d(string, new Object[]{adminData.name});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("admin");
        return true;
    }

    public boolean updateAdminPw(String string) {
        if (!this.a(string)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string2 = "update admin set admin_pw = ?";
        boolean bl = b2.d(string2, new Object[]{DigestUtils.shaHex((String)string)});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("admin");
        return true;
    }

    public boolean updateClientPw(String string) {
        if (!this.a(string)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string2 = "update admin set client_pw = ?";
        boolean bl = b2.d(string2, new Object[]{string});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("config");
        return true;
    }

    public boolean updateReportPw(String string) {
        if (!this.a(string)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string2 = "update admin set report_pw = ?";
        boolean bl = b2.d(string2, new Object[]{string});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("config");
        return true;
    }

    public boolean isAdminPw(String string) {
        AdminData adminData = this.selectOne();
        return DigestUtils.shaHex((String)string).equals(adminData.adminPw);
    }
}

