/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import org.tinyradius.dictionary.AttributeType;
import org.tinyradius.dictionary.DefaultDictionary;
import org.tinyradius.dictionary.Dictionary;
import org.tinyradius.util.RadiusException;
import org.tinyradius.util.RadiusUtil;

public class RadiusAttribute {
    private Dictionary dictionary = DefaultDictionary.getDefaultDictionary();
    private int attributeType = -1;
    private int vendorId = -1;
    private byte[] attributeData = null;

    public RadiusAttribute() {
    }

    public RadiusAttribute(int type, byte[] data) {
        this.setAttributeType(type);
        this.setAttributeData(data);
    }

    public byte[] getAttributeData() {
        return this.attributeData;
    }

    public void setAttributeData(byte[] attributeData) {
        if (attributeData == null) {
            throw new NullPointerException("attribute data is null");
        }
        this.attributeData = attributeData;
    }

    public int getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(int attributeType) {
        if (attributeType < 0 || attributeType > 255) {
            throw new IllegalArgumentException("attribute type invalid: " + attributeType);
        }
        this.attributeType = attributeType;
    }

    public void setAttributeValue(String value) {
        throw new RuntimeException("cannot set the value of attribute " + this.attributeType + " as a string");
    }

    public String getAttributeValue() {
        return RadiusUtil.getHexString(this.getAttributeData());
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(int vendorId) {
        this.vendorId = vendorId;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public byte[] writeAttribute() {
        if (this.getAttributeType() == -1) {
            throw new IllegalArgumentException("attribute type not set");
        }
        if (this.attributeData == null) {
            throw new NullPointerException("attribute data not set");
        }
        byte[] attr = new byte[2 + this.attributeData.length];
        attr[0] = (byte)this.getAttributeType();
        attr[1] = (byte)(2 + this.attributeData.length);
        System.arraycopy(this.attributeData, 0, attr, 2, this.attributeData.length);
        return attr;
    }

    public void readAttribute(byte[] data, int offset, int length) throws RadiusException {
        if (length < 2) {
            throw new RadiusException("attribute length too small: " + length);
        }
        int attrType = data[offset] & 0xFF;
        int attrLen = data[offset + 1] & 0xFF;
        byte[] attrData = new byte[attrLen - 2];
        System.arraycopy(data, offset + 2, attrData, 0, attrLen - 2);
        this.setAttributeType(attrType);
        this.setAttributeData(attrData);
    }

    public String toString() {
        AttributeType at = this.getAttributeTypeObject();
        String name = at != null ? at.getName() : (this.getVendorId() != -1 ? "Unknown-Sub-Attribute-" + this.getAttributeType() : "Unknown-Attribute-" + this.getAttributeType());
        if (this.getVendorId() != -1) {
            name = "  " + name;
        }
        return name + ": " + this.getAttributeValue();
    }

    public AttributeType getAttributeTypeObject() {
        if (this.getVendorId() != -1) {
            return this.dictionary.getAttributeTypeByCode(this.getVendorId(), this.getAttributeType());
        }
        return this.dictionary.getAttributeTypeByCode(this.getAttributeType());
    }

    public static RadiusAttribute createRadiusAttribute(Dictionary dictionary, int vendorId, int attributeType) {
        RadiusAttribute attribute = new RadiusAttribute();
        AttributeType at = dictionary.getAttributeTypeByCode(vendorId, attributeType);
        if (at != null && at.getAttributeClass() != null) {
            try {
                attribute = (RadiusAttribute)at.getAttributeClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        attribute.setAttributeType(attributeType);
        attribute.setDictionary(dictionary);
        attribute.setVendorId(vendorId);
        return attribute;
    }

    public static RadiusAttribute createRadiusAttribute(int vendorId, int attributeType) {
        Dictionary dictionary = DefaultDictionary.getDefaultDictionary();
        return RadiusAttribute.createRadiusAttribute(dictionary, vendorId, attributeType);
    }

    public static RadiusAttribute createRadiusAttribute(int attributeType) {
        Dictionary dictionary = DefaultDictionary.getDefaultDictionary();
        return RadiusAttribute.createRadiusAttribute(dictionary, -1, attributeType);
    }
}

