<%@include file="include/zop,header.jsp"%>
<%!
//-----------------------------------------------
void update(WhitelistDomainDao dao){
	WhitelistData data = new WhitelistData();
	data.id = paramInt("id");
	data.description = paramString("description");

	data.bypassFilter = paramBoolean("bypassFilter");
	data.adminBlock = paramBoolean("adminBlock");
	data.appliedPolicyArr = paramArray("appliedPolicyArr");

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Check refresh without id.
if(!checkEditId("zop,whitelist,domain.jsp")){
	return;
}

// Create data access object.
WhitelistDomainDao dao = new WhitelistDomainDao(getOpId());

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
WhitelistData data = dao.selectOne(paramInt("id"));

// Get policy list.
List<PolicyData> gPolicyList = new PolicyDao(getOpId()).selectList();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionUpdate(form){
	form.actionFlag.value = "update";
	form.submit();
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="<%= data.id%>">

<!--  -->
<fieldset>
<legend>WHITELIST</legend>
<table class="view">

	<tr>
		<td width="200">Domain</td>
		<td><%= data.domain%></td>
	</tr>

	<tr>
		<td>Description</td>
		<td>
		<input type="text" name="description" value="<%= data.description%>" size="50">
		</td>
	</tr>

	<tr>
		<td>Bypass Filtering</td>
		<td>
			<input type="checkbox" class="no-border" name="bypassFilter" <%if(data.bypassFilter){out.print("checked");}%>>
		</td>
	</tr>

	<tr>
		<td>Admin Block</td>
		<td>
			<input type="checkbox" class="no-border" name="adminBlock" <%if(data.adminBlock){out.print("checked");}%>>
		</td>
	</tr>

	<tr>
		<td valign="top">
			Applied Policy
			<i class="fa fa-question-circle south-east" title="If there's no applied policy it becomes a global whitelist."></i>
		</td>
		<td>
<%
for(PolicyData pd : gPolicyList){
%>
			<input type="checkbox" class="no-border"
				name="appliedPolicyArr" value="<%= pd.id%>" <%if(data.isAppliedPolicy(pd.id)){out.print("checked");}%>><%= pd.name%>
			<br>
<%}%>
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:actionUpdate(this.form)">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<%@include file="include/zop,footer.jsp"%>
