<%@include file="include/zop,header.jsp"%>
<%!
//-----------------------------------------------
boolean checkParam(UserData data){
	// Check password only if there's a password updated.
	if (!isEmpty(data.passwd) && !isSha1Hex(data.passwd)) {
		if (!ParamTest.isValidPasswdLen(data.passwd)) {
			errList.add(ParamTest.ERR_PASSWD_LEN);
			return false;
		}

		if (!ParamTest.isValidPasswdChar(data.passwd)) {
			errList.add(ParamTest.ERR_PASSWD_CHAR);
			return false;
		}
	}

	// token.
	if (!isEmpty(data.token) && !ParamTest.isValidToken(data.token)) {
		errList.add(ParamTest.ERR_TOKEN_INVALID);
		return false;
	}

	return true;
}

//-----------------------------------------------
void update(UserDao dao){
	UserData data = new UserData();
	data.id = paramInt("id");
	data.passwd = paramString("passwd");
	data.policyId = paramInt("policyId");
	data.ftPolicyId = paramInt("ftPolicyId");
	data.description = paramString("description");

	// Validate and update it.
	if(checkParam(data) && dao.update(data)){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void newToken(UserDao dao){
	if(dao.newToken(paramInt("id"))){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void addIp(UserDao dao){
	UserIpData data = new UserIpData();
	data.userId = paramInt("id");
	data.startIp = paramString("startIp");
	data.endIp = paramString("endIp");

	// Param validation.
	if (!isValidIp(data.startIp) && !isValidDomain(data.startIp)) {
		errList.add("Invalid IP or domain.");
		return;
	}

	if (isValidIp(data.endIp) && (!isPrivateIp(data.startIp) || !isPrivateIp(data.endIp))) {
		errList.add("Only private IP range allowed.");
		return;
	}

	if(ParamTest.hasMaxUserIpForOperator(getOpId())){
		errList.add("Can't add more IP.");
		return;
	}

	if(ParamTest.isDupUserIp(data.startIp)){
		errList.add("IP already exists.");
		return;
	}

	if(dao.addIp(data)){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void deleteIp(UserDao dao){
	if(dao.deleteIp(paramInt("ipId"))){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Check refresh without id.
if(!checkEditId("zop,user,user.jsp")){
	return;
}

// Create data access object.
UserDao dao = new UserDao(getOpId());

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("newToken")){
	newToken(dao);
}
if(actionFlag.equals("addIp")){
	addIp(dao);
}
if(actionFlag.equals("deleteIp")){
	deleteIp(dao);
}

// Global.
UserData data = dao.selectOne(paramInt("id"));

// Get policy list.
List<PolicyData> gPolicyList = new PolicyDao(getOpId()).selectList();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionNewToken(form){
	form.actionFlag.value = "newToken";
	form.submit();
}

//-----------------------------------------------
function actionUpdate(form){
	form.actionFlag.value = "update";
	form.submit();
}

//-----------------------------------------------
function actionAddIp(form){
	form.actionFlag.value = "addIp";
	form.submit();
}

//-----------------------------------------------
function actionDeleteIp(ipId){
	form = document.all("userEditForm");
	form.actionFlag.value = "deleteIp";
	form.ipId.value = ipId;
	form.submit();
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post" name="userEditForm">
<input type="hidden" name="actionFlag" value="EDIT">
<input type="hidden" name="id" value="<%= data.id%>">
<input type="hidden" name="ipId" value="">

<!--  -->
<fieldset>
<legend>USER</legend>
<table class="view">
	<tr>
		<td width="200">Name</td>
		<td>
			<%= data.name%>
		</td>
	</tr>

	<tr>
		<td>Password</td>
		<td><input type="password" name="passwd" size="50" maxlength="12" value="<%= data.passwd%>"></td>
	</tr>

	<tr>
		<td>Work-time Policy</td>
		<td>
			<select name="policyId">
<%
for(PolicyData pd : gPolicyList){
	if(pd.id == data.policyId){
		printf("<option value='%s' selected>%s\n", pd.id, pd.name);
	}
	else{
		printf("<option value='%s'>%s\n", pd.id, pd.name);
	}
}
%>
			</select>
		</td>
	</tr>

	<tr>
		<td>Free-time Policy</td>
		<td>
			<select name="ftPolicyId">
<%
for(PolicyData pd : gPolicyList){
	if(pd.id == data.ftPolicyId){
		printf("<option value='%s' selected>%s\n", pd.id, pd.name);
	}
	else{
		printf("<option value='%s'>%s\n", pd.id, pd.name);
	}
}
%>
			</select>
		</td>
	</tr>

	<tr>
		<td>Login Token</td>
		<td>
			<input type="text" name="token" size="8" maxlength="8" value="<%= data.token%>">
			<input type="button" value="NEW-TOKEN" onclick="javascript:actionNewToken(this.form)">
		</td>
	</tr>

	<tr>
		<td>Description</td>
		<td><input type="text" name="description" size="50" value="<%= data.description%>"></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:actionUpdate(this.form);">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
<legend>ADD IP</legend>
<table class="view">

	<tr>
		<td colspan="2">
		You can associate an IP address or a dynamic domain to a user. When you add an IP address range,<br>
		only private IP addresses will be allowed. If it is a single IP or domain association, add 'Start IP' only.
		</td>
	</tr>

	<tr>
		<td colspan="2">
		</td>
	</tr>
	<tr>
		<td colspan="2">
		Your current IP is <%= request.getRemoteAddr()%>.
		</td>
	</tr>

	<tr>
		<td width="120">Start IP</td>
		<td>
		<input type="text" name="startIp" size="25">
		<input type="button" value="ADD" onclick="javascript:actionAddIp(this.form)">
		</td>
	</tr>

	<tr>
		<td>End IP</td>
		<td>
		<input type="text" name="endIp" size="25">
		</td>
	</tr>

	<tr>
		<td colspan="2">
<%
for(int i = 0; i < data.ipList.size(); i++){
	UserIpData uip = data.ipList.get(i);

	if(i > 0 && i % 4 == 0){
		out.print("<br>");
	}

	printf("<span class='domain-item'><a href='javascript:actionDeleteIp(%s)'>[x]</a> %s</span>", uip.id, uip.asString());
}
%>
		</td>
	</tr>

</table>
</fieldset>

</form>
<!-- /view -->

<%@include file="include/zop,footer.jsp"%>
