<%@include file="include/zop,header.jsp"%>
<%!
//-----------------------------------------------
void insert(UserDao dao){
	UserData data = new UserData();
	data.name = paramString("name");
	data.description = paramString("description");

	// Param validation.
	if(!ParamTest.isValidNameLen(data.name)){
		errList.add(ParamTest.ERR_NAME_LEN);
		return;
	}
	
	if(!ParamTest.isValidUsernameChar(data.name)){
		errList.add(ParamTest.ERR_USERNAME_CHAR);
		return;
	}

	if (ParamTest.isDupUser(data.name, getOpId())) {
		errList.add("User already exists.");
		return;
	}

	if(ParamTest.hasMaxUserForOperator(getOpId())){
		errList.add("Can't add more user.");
		return;
	}

	if(dao.insert(data)){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void delete(UserDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	if(dao.delete(paramInt("id"))){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
UserDao dao = new UserDao(getOpId());
dao.limit = 1000;

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("insert")){
	insert(dao);
}
if(actionFlag.equals("delete")){
	delete(dao);
}

// Global.
int gCount = dao.selectCount();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionDelete(id, name){
	if(!confirm("Deleting user : " + name)){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "delete";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
function goEdit(id){
	var form = document.goForm;
	form.action = "zop,user,user_edit.jsp";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
function goTest(name){
	var form = document.goForm;
	form.action = "zop,user,user_test.jsp";
	form.name.value = name;
	form.submit();
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="insert">

<fieldset>
<legend>USER</legend>
<table class="view">

	<tr>
		<td width="200">Name</td>
		<td>
			<input type="text" name="name" size="50">
		</td>
	</tr>

	<tr>
		<td>Description</td>
		<td>
			<input type="text" name="description" size="50">
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<!-- list -->
<table width="100%">
	<tr>
		<td width="50%">
			Count : <%= gCount%>
		</td>
		<td align="right">
		</td>
	</tr>
</table>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="200">&nbsp;Name</td>
		<td width="100">Login Token</td>
		<td width="200">IP</td>
		<td width="400">Policy</td>
		<td width="">Description</td>
		<td width="150"></td>
	</tr>

<%
List<UserData> dataList = dao.selectList();
if(dataList.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='6' align='center'>No data</td>");
	out.println("</tr>");
}

for(int i = 0; i < dataList.size(); i++){
	UserData data = dataList.get(i);

	String name = data.name;
	if(data.systemFlag){
		name = "*" + name;
	}

	String ipLine = data.getIpLine();
	if(ipLine.length() == 0){
		ipLine = "Dynamic";
	}

	// Add free-time policy.
	if(!isEmpty(data.ftPolicyName)){
		data.policyName += " / " + data.ftPolicyName;
	}

	if(i > 0){
		out.println("<tr class='line'><td colspan='6'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= name%></td>
		<td><%= data.token%></td>
		<td class="ellipsis" style="width: 200px"><%= ipLine%></td>
		<td><%= data.policyName%></td>
		<td><%= data.description%></td>
		<td align="right">
			<input type="button" value="TEST" onclick="javascript:goTest('<%= data.name%>')">
			<input type="button" value="EDIT" onclick="javascript:goEdit(<%= data.id%>)">
			<input type="button" value="DEL" onclick="javascript:actionDelete(<%= data.id%>, '<%= data.name%>')">
		</td>
	</tr>
<%}%>

	<tr class="line"><td colspan="6"></td></tr>
</table>
<!-- /list -->

<!-- goForm -->
<form action="<%= getPageName()%>" name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="">
<input type="hidden" name="name" value="">
</form>
<!-- /goForm -->

<%@include file="include/zop,footer.jsp"%>
