<%@include file="include/zop,header.jsp"%>
<%!
//-----------------------------------------------
void update(OperatorDao dao){
	// Get old data.
	OperatorData data = dao.selectOne(getOpId());

	// Replace some values.
	data.email = paramString("email");
	data.alertPeriod = paramInt("alertPeriod");

	data.alertCategoryArr = paramArray("alertCategoryArr");

	// Param validation.
	if (data.alertPeriod > 0 && !isValidEmail(data.email)) {
		errList.add("Invalid email address.");
		return;
	}

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void updatePw(OperatorDao dao){
	String newPw = paramString("newPw");
	String newPw2 = paramString("newPw2");
	String adminPw = paramString("adminPw");

	// Validate and update it.
	if(newPw.length() < 4 || !ParamTest.isValidPasswdLen(newPw)){
		errList.add("Password length must be between 4 and 128.");
		return;
	}
	
	if(!ParamTest.isValidPasswdChar(newPw)){
		errList.add("Only ascii character allowed in password.");
		return;
	}

	if(!dao.isOperatorPw(adminPw)){
		errList.add("Wrong password.");
		return;
	}
	
	if(!newPw.equals(newPw2)){
		errList.add("Passwords don't match.");
		return;
	}

	// Get old data.
	OperatorData data = dao.selectOne(getOpId());

	// Replace some values.
	data.passwd = newPw;

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
OperatorDao dao = new OperatorDao(getOpId());

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("updatePw")){
	updatePw(dao);
}

// Global.
OperatorData data = dao.selectOne(getOpId());
%>
<%@include file="include/action_info.jsp"%>

<!-- Admin password -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="updatePw">

<fieldset>
<legend>ADMIN PASSWORD</legend>
<table class="view">

	<tr>
		<td width="200">Current Password</td>
		<td><input type="password" name="adminPw" size="50"></td>
	</tr>

	<tr>
		<td>New Password</td>
		<td><input type="password" name="newPw" size="50"></td>
	</tr>

	<tr>
		<td>Confirm Password</td>
		<td><input type="password" name="newPw2" size="50"></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /Admin password -->

<!-- Alert -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<fieldset>
<legend>ALERT</legend>
<table class="view">

	<tr>
		<td width="200">Email</td>
		<td><input type="text" name="email" value="<%= data.email%>" size="50"></td>
	</tr>

	<tr>
		<td>Alert Period</td>
		<td>
			<select name="alertPeriod">
<%
Map<Integer, String> period_map = getAlertPeriodMap();
for(Map.Entry<Integer, String> entry : period_map.entrySet()){
	Integer key = entry.getKey();
	String val = entry.getValue();

	if(key == data.alertPeriod){
		printf("<option value='%s' selected>%s", key, val);
	}
	else{
		printf("<option value='%s'>%s", key, val);
	}
}
%>
			</select>
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
<legend>ALERT CATEGORIES</legend>
<table class="view">

	<tr>
		<td colspan="2">
<div style="line-height:20px;">
This is for when you block domains by categories in a policy. Blocking by other means will not be affected.
</div>
		</td>
	</tr>

	<tr>
		<td colspan="2">

<%
for(int i = 0; i < data.alertCategoryList.size(); i++){
	CategoryData cd = data.alertCategoryList.get(i);

	String chkLine = "";
	if(cd.checkFlag){
		chkLine = "checked";
	}

	if(i > 0 && i % 5 == 0){
		out.println("<br>");
	}
%>
			<span class="category-item">
				<input type="checkbox" class="no-border"
					name="alertCategoryArr" value="<%= cd.id%>" <%= chkLine%>><%= cd.name%>
			</span>
<%}%>

		</td>
	</tr>

	<tr>
		<td width="200"></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
			<input type="button" value="TOGGLE-ALL" onclick="javascript:checkboxToggleAll3('alertCategoryArr');"><br>
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /Alert -->

<%@include file="include/zop,footer.jsp"%>
