<%@include file="include/zop,header.jsp"%>
<%!
//-----------------------------------------------
void update(OpBlockPageDao dao){
	BlockPageData data = new BlockPageData();

	// We use requestString here to preserve all the special characters.
	data.blockPage = requestString("blockPage");

	data.sanitize();
	if(data.blockPage.length() > BlockPageData.OP_MAX_PAGE_SIZE){
		errList.add("Size too big.");
		return;
	}

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
OpBlockPageDao dao = new OpBlockPageDao(getOpId());

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
BlockPageData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function preview(text){
	var w = window.open("", "preview_window", "width=1024,height=600");
	w.document.open();
	w.document.write(text);
	w.document.close();
}

//-----------------------------------------------
function restore_default(form){
	form.actionFlag.value = "restore";
	form.submit();
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<fieldset>
<legend>BLOCK PAGE</legend>
<table class="view">

	<tr>
		<td width="200" valign="top">
			Block page
			<i class="fa fa-question-circle south-east" title="You can edit your block-page here. When you don't have your own block-page,
				<br>the default block-page will be served.">
			</i>
		</td>
		<td>
			<textarea name="blockPage" cols="80" rows="16"><%= escapeHtml(data.blockPage)%></textarea>
			<input type="button" value="PREVIEW" onclick="javascript:preview(this.form.blockPage.value);">
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<%@include file="include/zop,footer.jsp"%>
