<%@include file="include/zop,header.jsp"%>
<%!
//-----------------------------------------------
void update(PolicyNxProxyDao dao){
	PolicyNxProxyData data = new PolicyNxProxyData();
	data.enableFilter = paramBoolean("enableFilter");
	data.localDns = paramString("localDns");
	data.localDomain = paramString("localDomain");
	data.autoSwitchDomain = paramString("autoSwitchDomain");
	data.useAutoSwitch = paramBoolean("useAutoSwitch");

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void newAutoSwitchDomain(PolicyNxProxyDao dao){
	if(dao.newAutoSwitchDomain()){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
PolicyNxProxyDao dao = new PolicyNxProxyDao(getOpId());

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("newAutoSwitchDomain")){
	newAutoSwitchDomain(dao);
}

// Global.
PolicyNxProxyData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionNewAutoSwitchDomain(form){
	form.actionFlag.value = "newAutoSwitchDomain";
	form.submit();
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<fieldset>
<legend>NXPROXY</legend>
<table class="view">

	<tr>
		<td width="200">Enable Filter</td>
		<td>
		<input type="checkbox" class="no-border" name="enableFilter"
			<%if(data.enableFilter){out.print("checked");}%>> NxProxy is a DNS (DoH) level remote filtering agent.
			</td>
	</tr>

	<tr>
		<td>
			Local Domain
			<i class="fa fa-question-circle south-east" title="This is for bypassing local domains. You can add multiple domains separated by spaces.
				<br>&nbsp;&nbsp;ex) www.nxfilter.local *.jahastech.local"></i>
		</td>
		<td>
			<textarea name="localDomain" cols="80" rows="8"><%= data.localDomain%></textarea>
		</td>
	</tr>

	<tr>
		<td>
			Local DNS Server
			<i class="fa fa-question-circle south-east" title="This is optional. NxProxy will try to find the DNS server in its network by itself.
				<br>This is for when you want to specify your own DNS server for sure."></i>
		</td>
		<td>
		<input type="text" name="localDns" value="<%= data.localDns%>" size="50"
			class="east" title="Multiple IP addresses should be separated by commas.">
		</td>
	</tr>

	<tr>
		<td>
			Auto-switch Domain
			<i class="fa fa-question-circle south-east" title="Auto-switch domain is for NxProxy to find its local network under DNS filtering.
				When it finds itself in its local network
				<br>with auto-switching enabled it will bypass everything to its filtering server."></i>
		</td>
		<td>
			<input type="text" name="autoSwitchDomain"\ value="<%= data.autoSwitchDomain%>" size="50">
		</td>
	</tr>

	<tr>
		<td>
			Use Auto-switching
		</td>
		<td><input type="checkbox" class="no-border"
			name="useAutoSwitch" <%if(data.useAutoSwitch){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
			<input type="button" value="NEW AUTO-SWITCH DOMAIN" onclick="javascript:actionNewAutoSwitchDomain(this.form);">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<%@include file="include/zop,footer.jsp"%>
