<%@include file="include/zop,header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
ZopRequestDao dao = new ZopRequestDao(getAdminName());

// Set filtering option.
dao.limit = 50;
dao.page = paramInt("page", 1);
dao.stime = paramString("stime");
dao.etime = paramString("etime");

dao.domain = paramString("domain");
dao.user = paramString("user");

dao.cltIp = paramString("cltIp");
dao.policy = paramString("policy");
dao.category = paramString("category");
dao.blockFlag = paramBoolean("blockFlag");

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("csv")){
	String filename = "logging-request.csv";
	
	// Don't make it too big.
	dao.limit = 10000;
	if(dao.writeCsvFile(filename)){
		response.sendRedirect("download.jsp?filename=" + filename + "&contentType=text/csv");
		return;
	}
	else{
		errList.add("Couldn't write the file.");
	}
}

// Global.
int gCount = dao.selectCount();
int gPage = dao.page;
int gLimit = dao.limit;
String gTimeOption = paramString("timeOption", "2h");
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionCsv(){
	var form = document.searchForm;
	form.actionFlag.value = "csv";
	form.submit();
}

//-----------------------------------------------
function goPage(page){
	var form = document.goForm;
	form.page.value = page;
	form.submit();
}

//-----------------------------------------------
function setUserdef(form){
	form.timeOption[0].checked = true;
}

//-----------------------------------------------
function setPeriod(form){
	var opt = radioGetValue(form.timeOption);
	if(opt == 'userdef'){
		return;
	}

	var stime = '<%= strftimeAdd(getGuiTimeFormatWithYear(), -3600 * 2)%>';
	var etime = '<%= strftime(getGuiTimeFormatWithYear())%>';

	if(opt == "24h"){
		stime = '<%= strftimeAdd(getGuiTimeFormatWithYear(), -3600 * 24)%>';
	}

	if(opt == "48h"){
		stime = '<%= strftimeAdd(getGuiTimeFormatWithYear(), -3600 * 48)%>';
	}

	form.stime.value = stime;
	form.etime.value = etime;
	form.stime.disabled = false;
	form.etime.disabled = false;
}

//-----------------------------------------------
function setPeriod2(form){
	if(!radioIsChecked(form.timeOption) || form.timeOption[0].checked){
		return;
	}
	setPeriod(form);
}

//-----------------------------------------------
function clearSearchForm(){
	document.searchForm.domain.value = "";
	document.searchForm.user.value = "";
	document.searchForm.cltIp.value = "";

	document.searchForm.policy.value = "";
	document.searchForm.category.value = "";
	document.searchForm.blockFlag.checked = false;
}
</script>

<!-- view -->
<form name="searchForm" action="<%= getPageName()%>" method="get">
<input type="hidden" name="actionFlag" value="">

<fieldset>
<legend>DNS REQUEST</legend>
<table class="view">

	<tr>
		<td width="100" align="right">Time :</td>
		<td colspan="7">
			<input id="stime" type="text" name="stime" value="<%= dao.getStime()%>" size="12" onchange="javascript:setUserdef(this.form)">
				~ <input id="etime" type="text" name="etime" value="<%= dao.getEtime()%>" size="12" onchange="javascript:setUserdef(this.form)">
			
			<div style="display: none;">
				<input type="radio" class="no-border" name="timeOption" value="userdef" onclick="javascript:setPeriod(this.form)"
					<%if(gTimeOption.equals("userdef")){out.print("checked");}%>> User defined
			</div>

			<input type="radio" class="no-border" name="timeOption" value="2h" onclick="javascript:setPeriod(this.form)"
				<%if(gTimeOption.equals("2h")){out.print("checked");}%>> Last 2 hours
			<input type="radio" class="no-border" name="timeOption" value="24h" onclick="javascript:setPeriod(this.form)"
				<%if(gTimeOption.equals("24h")){out.print("checked");}%>> Last 24 hours
			<input type="radio" class="no-border" name="timeOption" value="48h" onclick="javascript:setPeriod(this.form)"
				<%if(gTimeOption.equals("48h")){out.print("checked");}%>> Last 48 hours
		</td>
	</tr>

	<tr>
		<td width="100" align="right">Domain :</td>
		<td width="100"><input type="text" name="domain" value="<%= dao.domain%>" size="25"></td>
		
		<td width="100" align="right">User :</td>
		<td width="100"><input type="text" name="user" value="<%= dao.user%>" size="25"></td>

		<td width="100" align="right">Client IP :</td>
		<td width="100"><input type="text" name="cltIp" value="<%= dao.cltIp%>" size="25"></td>
		
		<td width="60"></td>
		<td ></td>
	</tr>

	<tr>
		<td align="right">Policy :</td>
		<td><input type="text" name="policy" value="<%= dao.policy%>" size="25"></td>

		<td align="right">Category :</td>
		<td><input type="text" name="category" value="<%= dao.category%>" size="25"></td>
		
		<td align="right">Block :</td>
		<td><input type="checkbox" class="no-border" name="blockFlag" <%if(dao.blockFlag){out.print("checked");}%>></td>

		<td align="right"></td>
		<td></td>
	</tr>

	<tr>
		<td></td>
		<td></td>
		<td></td>
		<td colspan="5">
			<input type="button" value="SUBMIT" onclick="javascript:setPeriod2(this.form);this.form.actionFlag.value='';this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
			<input type="button" value="CLEAR" onclick="javascript:clearSearchForm();">
			<input type="button" value="CSV-EXPORT" onclick="javascript:actionCsv();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<!-- list -->
<table width="100%">
	<tr>
		<td>
			Count : <%= gCount%> / Page : <%= dao.page%>
		</td>
	</tr>
</table>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="90">Time</td>
		<td width="50" align="center">Count</td>
		<td width="60" align="center">Type</td>
		<td width="400">Domain</td>
		<td width="180">User</td>
		<td width="150">Client IP</td>
		<td width="180">Operator</td>
		<td width="180">Policy</td>
		<td width="">Category</td>
	</tr>
<%
List<RequestData> dataList = dao.selectList();
if(dataList.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='9' align='center'>No data</td>");
	out.println("</tr>");
}

for(int i = 0; i < dataList.size(); i++){
	RequestData data = dataList.get(i);

	String categoryLine = data.category;
	if(categoryLine.length() > 30){
		categoryLine = safeSubstring(categoryLine, 30) + "..";
	}

	String domainStyle = "";
	String domainReason = "";
	if(data.getBlockYn().equals("Y")){
		domainStyle = "background-color: #FF7518; color: #FFFFFF; padding: 2px;";
		domainReason = "<span class='logging-reason'>" + data.getReason() + "</span>";
	}

	if(data.getBlockYn().equals("Y") && data.getReason().contains("category")){
		categoryLine = "<span class='logging-category'>" + categoryLine + "</span>";
	}

	if(i > 0){
		out.println("<tr class='line'><td colspan='10'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= data.getCtime()%></td>
		<td align="right"><%= data.cnt%>&nbsp;&nbsp;</td>
		<td align="center"><%= data.getTypeCode()%></td>
		<td><span style="<%= domainStyle%>"><%= data.domain%></span> <%= domainReason%></td>
		<td><%= data.user%></td>
		<td><%= data.cltIp%></td>
		<td><%= data.operator%></td>
		<td><%= data.policy%></td>
		<td title="<%= data.category%>"><%= categoryLine%></td>
	</tr>
<%}%>

	<tr class="line"><td colspan="9"></td></tr>
</table>
<!-- /list -->

<!-- pagination -->
<table width="100%">
	<tr>
		<td width="50%">
		</td>
		<td align="right">
			<div class="pagination"> 
				<%= getPagination2(gCount, gLimit, gPage)%>
			</div> 
		</td>
	</tr>
</table>
<!-- /pagination -->

<!-- goForm -->
<form action="<%= getPageName()%>" name="goForm" method="get">
<input type="hidden" name="page" value="<%= gPage%>">
<input type="hidden" name="timeOption" value="<%= gTimeOption%>">
<input type="hidden" name="stime" value="<%= dao.stime%>">
<input type="hidden" name="etime" value="<%= dao.etime%>">
<input type="hidden" name="domain" value="<%= dao.domain%>">
<input type="hidden" name="user" value="<%= dao.user%>">
<input type="hidden" name="cltIp" value="<%= dao.cltIp%>">
<input type="hidden" name="policy" value="<%= dao.policy%>">
<input type="hidden" name="category" value="<%= dao.category%>">
<input type="hidden" name="blockFlag" value="<%= dao.blockFlag%>">
</form>
<!-- /goForm -->

<%@include file="include/zop,footer.jsp"%>

<!-- Datetime picker -->
<script type="text/javascript">
//-----------------------------------------------
var dateToDisable = new Date();

//-----------------------------------------------
jQuery("#stime").datetimepicker({
	format: "<%= getGuiDateFormatForPicker()%> H:i",
	step: 1,
	beforeShowDay: function(date) {
		if (date.getTime() > dateToDisable.getTime() || date.getDate() > dateToDisable.getDate()) {
			return [false, ""]
		}

		return [true, ""];
	}
});

//-----------------------------------------------
jQuery("#etime").datetimepicker({
	format: "<%= getGuiDateFormatForPicker()%> H:i",
	step: 1,
	beforeShowDay: function(date) {
		if (date.getTime() > dateToDisable.getTime() || date.getDate() > dateToDisable.getDate()) {
			return [false, ""]
		}

		return [true, ""];
	}
});
</script>
