<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
boolean checkParam(AlertData data){
	if (isNotEmpty(data.adminEmail) && !isValidEmail(data.adminEmail)) {
		errList.add("Invalid email address.");
		return false;
	}

	return true;
}

//-----------------------------------------------
void update(AlertDao dao){
	AlertData data = new AlertData();

	data.adminEmail = paramString("adminEmail");
	data.smtpHost = paramString("smtpHost");
	data.smtpPort = paramInt("smtpPort");
	data.smtpEncType = paramInt("smtpEncType");
	data.smtpUser = paramString("smtpUser");
	data.smtpPasswd = paramString("smtpPasswd");

	// Validate and update it.
	if(checkParam(data) && dao.update(data)){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void test(AlertDao dao){
	AlertData data = new AlertData();

	data.adminEmail = paramString("adminEmail");
	data.smtpHost = paramString("smtpHost");
	data.smtpPort = paramInt("smtpPort");
	data.smtpEncType = paramInt("smtpEncType");
	data.smtpUser = paramString("smtpUser");
	data.smtpPasswd = paramString("smtpPasswd");

	// Validate and update it.
	if(!checkParam(data) || !dao.update(data)){
		return;
	}

	try{
		dao.test();
		succList.add("Test email has been sent.");
	}
	catch(Exception e){
		errList.add(e.toString());
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
AlertDao dao = new AlertDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("test")){
	test(dao);
}

// Global.
AlertData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionTest(form){
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "test";
	form.submit();
}
</script>

<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<!--  -->
<fieldset>
	<legend>ALERT</legend>
<table class="view">

	<tr>
		<td width="200">Admin Email</td>
		<td><input type="text" name="adminEmail" value="<%= data.adminEmail%>" size="50"></td>
	</tr>

	<tr>
		<td>SMTP Host</td>
		<td><input type="text" name="smtpHost" value="<%= data.smtpHost%>" size="50"></td>
	</tr>

	<tr>
		<td>SMTP Port</td>
		<td><input type="text" name="smtpPort" value="<%= data.smtpPort%>" size="2"></td>
	</tr>

	<tr>
		<td>SSL/TLS</td>
		<td>
			<input type="radio" class="no-border" name="smtpEncType" value="0" <%if(data.smtpEncType == 0){out.print("checked");}%>> None
			<input type="radio" class="no-border" name="smtpEncType" value="1" <%if(data.smtpEncType == 1){out.print("checked");}%>> SSL
			<input type="radio" class="no-border" name="smtpEncType" value="2" <%if(data.smtpEncType == 2){out.print("checked");}%>> STARTTLS
		</td>
	</tr>

	<tr>
		<td>SMTP User</td>
		<td><input type="text" name="smtpUser" value="<%= data.smtpUser%>" size="50"></td>
	</tr>

	<tr>
		<td>SMTP Password</td>
		<td><input type="password" name="smtpPasswd" value="<%= data.smtpPasswd%>" size="50"></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
			<input type="button" value="TEST" onclick="javascript:actionTest(this.form);">
		</td>
	</tr>

</table>
</fieldset>
</form>

<%@include file="include/footer.jsp"%>
