<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void updateName(AdminDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	AdminData data = new AdminData();
	data.name = paramString("adminName");

	// Param validation.
	if(!ParamTest.isValidNameLen(data.name)){
		errList.add(ParamTest.ERR_NAME_LEN);
		return;
	}
	
	if(!ParamTest.isValidNameChar(data.name)){
		errList.add(ParamTest.ERR_NAME_CHAR);
		return;
	}

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void updateAdminPw(AdminDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	String newPw = paramString("newPw");
	String newPw2 = paramString("newPw2");
	String adminPw = paramString("adminPw");

	// Validate and update it.
	if(!ParamTest.isValidPasswdLen(newPw)){
		errList.add(ParamTest.ERR_PASSWD_LEN);
		return;
	}
	
	if(!ParamTest.isValidPasswdChar(newPw)){
		errList.add(ParamTest.ERR_PASSWD_CHAR);
		return;
	}

	if(!dao.isAdminPw(adminPw)){
		errList.add("Wrong password.");
		return;
	}

	if(!newPw.equals(newPw2)){
		errList.add("Passwords don't match.");
		return;
	}

	if(dao.updateAdminPw(newPw)){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void updateMagicPw(AdminDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	String magicPw = paramString("magicPw");
	String magicPw2 = paramString("magicPw2");
	String adminPw = paramString("adminPw");

	// Validate and update it.
	if(magicPw.length() < 4 || !ParamTest.isValidPasswdLen(magicPw)){
		errList.add("Password length must be between 4 and 128.");
		return;
	}
	
	if(!ParamTest.isValidPasswdChar(magicPw)){
		errList.add("Only ascii character allowed in password.");
		return;
	}

	if(!dao.isAdminPw(adminPw)){
		errList.add("Wrong password.");
		return;
	}

	if(!magicPw.equals(magicPw2)){
		errList.add("Passwords don't match.");
		return;
	}

	if(dao.updateMagicPw(magicPw)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
AdminDao dao = new AdminDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	updateName(dao);
}
if(actionFlag.equals("adminPw")){
	updateAdminPw(dao);
}
if(actionFlag.equals("magicPw")){
	updateMagicPw(dao);
}

// Global.
AdminData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>

<!-- Admin name -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<fieldset>
	<legend>ADMIN NAME</legend>
<table class="view">

	<tr>
		<td width="200">Admin Name</td>
		<td><input type="text" name="adminName" value="<%= data.name%>" size="50"></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- / -->

<!-- Admin password -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="adminPw">

<fieldset>
	<legend>ADMIN PASSWORD</legend>
<table class="view">

	<tr>
		<td width="200">Current Password</td>
		<td><input type="password" name="adminPw" size="50"></td>
	</tr>

	<tr>
		<td>New Password</td>
		<td><input type="password" name="newPw" size="50"></td>
	</tr>

	<tr>
		<td>Confirm Password</td>
		<td><input type="password" name="newPw2" size="50"></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!--  -->

<!-- Magic password -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="magicPw">

<fieldset>
	<legend>
		MAGIC PASSWORD
		<i class="fa fa-question-circle south-east" title="You can login to any operator GUI with this password."></i>
	</legend>
<table class="view">

	<tr>
		<td width="200">Admin Password</td>
		<td><input type="password" name="adminPw" size="50"></td>
	</tr>

	<tr>
		<td>New Password</td>
		<td><input type="password" name="magicPw" size="50"></td>
	</tr>

	<tr>
		<td>Confirm Password</td>
		<td><input type="password" name="magicPw2" size="50"></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!--  -->

<%@include file="include/footer.jsp"%>
