<%@include file="include/xop,header.jsp"%>
<%!
//-----------------------------------------------
void insert(SignupRequestDao dao){
	SignupRequestData data = new SignupRequestData();

	data.username = paramString("username");
	data.passwd = paramString("passwd");
	data.email = paramString("email");

	data.type = 1;  // 1 = Business, 2 = Home.

	String confirmPasswd = paramString("confirmPasswd");
 
	// Param validation.
	if(isEmpty(data.username)){
		jsAlert("Username missing!");
		return;
	}
	
	// Username.
	if(data.username.length() > 20){
		jsAlert("Username too long!");
		return;
	}
	
	if(!ParamTest.isValidUsernameChar(data.username)){
		jsAlert(ParamTest.ERR_USERNAME_CHAR);
		return;
	}

	if (ParamTest.isDupSignupUsername(data.username)) {
		jsAlert("Username already exists.");
		return;
	}

	// Password.
	if(isEmpty(data.passwd)){
		jsAlert("Password missing!");
		return;
	}
	
	if(isEmpty(confirmPasswd)){
		jsAlert("Confirm your password!");
		return;
	}

	if(!data.passwd.equals(confirmPasswd)){
		errList.add("Passwords don't match.");
		return;
	}

	if(!ParamTest.isValidPasswdLen(data.passwd)){
		errList.add(ParamTest.ERR_PASSWD_LEN);
		return;
	}
	
	if(!ParamTest.isValidPasswdChar(data.passwd)){
		errList.add(ParamTest.ERR_PASSWD_CHAR);
		return;
	}

	// Email.
	if(isEmpty(data.email)){
		jsAlert("Email missing!");
		return;
	}

	if(data.email.length() > 50){
		jsAlert("Email too long!");
		return;
	}

	if(!data.email.contains("@")){
		jsAlert("Invalid email address!");
		return;
	}
	
	// Validate and update it.
	if(dao.insert(data)){
		jsAlertForward("Your signup request has been submitted.", "admin.jsp");
	}
}
%>
<%
//-----------------------------------------------
// Create data access object.
SignupRequestDao dao = new SignupRequestDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("insert")){
	insert(dao);
}

// Global.
String gUsername = paramString("username");
String gEmail = paramString("email");
%>
<div class="login-page">
<form method="post" action="<%= getPageName()%>">
<input type="hidden" name="actionFlag" value="insert">

<table cellspacing="0" cellpadding="4" bgcolor="#FFFFFF" width="320">

	<tr height="25">
		<td colspan="2" style="background-color: #A64D79; color: #FFFFFF; font-size: 9pt;">SIGNUP</td>
	</tr>

	<tr height="5">
		<td colspan="2"></td>
	</tr>

	<tr>
		<td width="110">&nbsp;Username</td>
		<td><input type="text" name="username" value="<%= gUsername%>"></td>
	</tr>

	<tr>
		<td>&nbsp;Password</td>
		<td><input type="password" name="passwd"></td>
	</tr>

	<tr>
		<td>&nbsp;Confirm Password</td>
		<td><input type="password" name="confirmPasswd"></td>
	</tr>

	<tr>
		<td>&nbsp;Email</td>
		<td><input type="text" name="email" value="<%= gEmail%>"></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();"><br>
		</td>
	</tr>

	<tr height="5">
		<td colspan="2"></td>
	</tr>

</table>
</div>

<%@include file="include/xop,footer.jsp"%>
