<%@include file="include/xop,header.jsp"%>
<%!
//-----------------------------------------------
void resetPw(OperatorDao dao){
	String username = paramString("username");

	OperatorData data = dao.selectOneByName(username);
	if(data == null){
		jsAlert("No such user found!");
		return;
	}

	if(isEmpty(data.email)){
		jsAlert("No email address associated!");
		return;
	}

	// New password.
	String newPw = dao.makeRandomPasswd();
	data.passwd = newPw;

	if(!dao.update(data)){
		jsAlert("Couldn't reset the password!");
		return;
	}

	// Reset password.
	String subj = "Your password has been reset.";
	String message = "Your new password : " + newPw;
	if(AlertDao.sendPasswordResetEmail(subj, message, data.email)){
		jsAlert("Your new password has been sent to your email address.");
	}
	else{
		jsAlert("Couldn't send an email!");
	}
}
%>
<%
//-----------------------------------------------
// Create data access object.
OperatorDao dao = new OperatorDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("resetPw")){
	resetPw(dao);
}
%>
<div class="login-page">
<form method="post" action="<%= getPageName()%>">
<input type="hidden" name="actionFlag" value="resetPw">

<table cellspacing="0" cellpadding="4" bgcolor="#FFFFFF" width="320">

	<tr height="25">
		<td colspan="2" style="background-color: #A64D79; color: #FFFFFF; font-size: 9pt;">RESET PASSWORD</td>
	</tr>

	<tr height="5">
		<td colspan="2"></td>
	</tr>

	<tr>
		<td colspan="2">
			&nbsp;You will receive a new password to your signup<br>
			&nbsp;email address.
		</td>
	</tr>

	<tr>
		<td width="110">&nbsp;Username</td>
		<td><input type="text" name="username"></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();"><br>
		</td>
	</tr>

	<tr height="5">
		<td colspan="2"></td>
	</tr>

</table>
</div>

<%@include file="include/xop,footer.jsp"%>
