<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Global.
String gUptime = new ConfigDao().getUptimeInfo();
%>

<script type="text/javascript">
//-----------------------------------------------
function setUserdef(form){
	form.timeOption[0].checked = true;
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="get">

<fieldset>
	<legend>USAGE REPORT</legend>
<table class="view">

	<tr>
		<td>
			Usage statistics for 30 days.
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<!-- list -->
<table width="100%">
	<tr>
		<td>
			Up <%= gUptime%>
		</td>
	</tr>
</table>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="90">Time</td>
		<td width="120" align="right">Request Sum</td>
		<td width="150" align="right">Request Count</td>
		<td width="150" align="right">Block Sum</td>
		<td width="150" align="right">Block Count</td>
		<td width="150" align="right">Domain Count</td>
		<td width="150" align="right">Operator Count</td>
		<td width="150" align="right">User Count</td>
		<td width="150" align="right">Client IP</td>
		<td width="150" align="right">Local IP</td>
		<td width=""></td>
	</tr>

<%
for(int i = 0; i < 30; i++){
	String stime = strftimeAdd("yyyyMMdd", (86400 * i * -1) - 1);

	D1ReportDao dao = new D1ReportDao(stime);
	ReportStatsData stats = dao.getStats();

	if(i > 0){
		out.println("<tr class='line'><td colspan='11'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= dao.getStime()%></td>
		<td align="right"><%= stats.reqSum%>&nbsp;</td>
		<td align="right"><%= stats.reqCnt%>&nbsp;</td>
		<td align="right"><%= stats.blockSum%>&nbsp;</td>
		<td align="right"><%= stats.blockCnt%>&nbsp;</td>
		<td align="right"><%= stats.domainCnt%>&nbsp;</td>
		<td align="right"><%= stats.opCnt%>&nbsp;</td>
		<td align="right"><%= stats.userCnt%>&nbsp;</td>
		<td align="right"><%= stats.cltIpCnt%>&nbsp;</td>
		<td align="right"><%= dao.getLocalIpCnt()%>&nbsp;</td>
		<td width=""></td>
	</tr>
<%}%>

	<tr class="line"><td colspan="11"></td></tr>
</table>
<!-- /list -->

<%@include file="include/footer.jsp"%>
