<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
OperatorStatsDao dao = new OperatorStatsDao();
dao.limit = 25;
dao.page = paramInt("page", 1);
dao.addKw(paramString("kw"));

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("csv")){
	String filename = "logging,operator-stats.csv";

	// Don't make it too big.
	dao.limit = 10000;
	if(dao.writeCsvFile(filename)){
		response.sendRedirect("download.jsp?filename=" + filename + "&contentType=text/csv");
		return;
	}
	else{
		errList.add("Couldn't write the file.");
	}
}

// Global.
int gCount = dao.selectCount();
int gPage = dao.page;
int gLimit = dao.limit;
String gKw = paramString("kw");
%>
<script type="text/javascript">
//-----------------------------------------------
function actionCsv(){
	var form = document.goForm;
	form.actionFlag.value = "csv";
	form.submit();
}

//-----------------------------------------------
function goPage(page){
	var form = document.goForm;
	form.page.value = page;
	form.submit();
}

//-----------------------------------------------
function goSearch(kw){
	var form = document.goForm;
	form.kw.value = document.all("searchKw").value;
	form.page.value = "1";
	form.submit();
}
</script>

<!-- view -->
<form name="searchForm" action="<%= getPageName()%>" method="get">
<input type="hidden" name="actionFlag" value="">

<fieldset>
	<legend>OPERATER STATISTICS</legend>
<table class="view">

	<tr>
		<td>
			Daily statistics for operators.
		</td>
	</tr>

	<tr>
		<td>
			<input type="button" value="CSV-EXPORT" onclick="javascript:actionCsv();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<!-- list -->
<table width="100%">
	<tr>
		<td width="50%">
			Count : <%= gCount%> / Page : <%= gPage%>
		</td>
		<td align="right">
			Search : <input type="text" name="searchKw" size="25" value="<%= gKw%>"
				onkeypress="javascript:if(event.keyCode == 13){goSearch(); return;}">
		</td>
	</tr>
</table>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="100">&nbsp;Time</td>
		<td width="150">Operator</td>
		<td width="150">Request (sum / cnt)</td>
		<td width="150">Block (sum / cnt)</td>
		<td width="100">Domain</td>
		<td width="100">User</td>
		<td width="100">Client IP</td>
		<td width="100">Local IP</td>
		<td width="100">Signal</td>
		<td width=""></td>
	</tr>

<%
List<OperatorStatsData> dataList = dao.selectList();
if(dataList.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='10' align='center'>No data</td>");
	out.println("</tr>");
}

for(int i = 0; i < dataList.size(); i++){
	OperatorStatsData data = dataList.get(i);

	if(i > 0){
		out.println("<tr class='line'><td colspan='10'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= data.getCtime()%></td>
		<td><%= data.operator%></td>
		<td><%= data.requestSum%> / <%= data.requestCnt%></td>
		<td><%= data.blockSum%> / <%= data.blockCnt%></td>
		<td><%= data.domainCnt%></td>
		<td><%= data.userCnt%></td>
		<td><%= data.cltIpCnt%></td>
		<td><%= data.localIpCnt%></td>
		<td><%= data.signalCnt%></td>
		<td></td>
	</tr>
<%}%>

	<tr class="line"><td colspan="10"></td></tr>
</table>
<!-- /list -->

<!-- pagination -->
<table width="100%">
	<tr>
		<td width="50%">
		</td>
		<td align="right">
			<div class="pagination"> 
				<%= getPagination2(gCount, gLimit, gPage)%>
			</div> 
		</td>
	</tr>
</table>
<!-- /pagination -->

<!-- goForm -->
<form action="<%= getPageName()%>" name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="page" value="<%= gPage%>">
<input type="hidden" name="kw" value="<%= gKw%>">
<input type="hidden" name="limit" value="<%= gLimit%>">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>
