<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void approve(SignupRequestDao dao){
	if(dao.approve(paramInt("id"))){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void delete(SignupRequestDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	if(dao.delete(paramInt("id"))){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
SignupRequestDao dao = new SignupRequestDao();
dao.page = paramInt("page", 1);
dao.addKw(paramString("kw"));

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("approve")){
	approve(dao);
}
if(actionFlag.equals("delete")){
	delete(dao);
}

// Global.
int gCount = dao.selectCount();
int gPage = dao.page;
int gLimit = dao.limit;
String gKw = paramString("kw");
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionApprove(id, uname){
	if(!confirm("Approve the signup request from " + uname)){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "approve";
	form.id.value = id;

	form.submit();
}

//-----------------------------------------------
function actionDelete(id, name){
	if(!confirm("Deleting signup request : " + name)){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "delete";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
function goPage(page){
	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.page.value = page;
	form.submit();
}

//-----------------------------------------------
function goSearch(kw){
	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.kw.value = document.all("searchKw").value;
	form.page.value = "1";
	form.submit();
}

//-----------------------------------------------
function goEdit(id){
	var form = document.goForm;
	form.action = "operator,operator_edit.jsp";
	form.id.value = id;
	form.submit();
}
</script>

<!-- view -->
<form>
<fieldset>
	<legend>Signup Request</legend>
<table class="view">

	<tr>
		<td>
You will have the signup requests from new users here.
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<!-- list -->
<table width="100%" class="with-top-margin">
	<tr>
		<td width="50%">
			Count : <%= gCount%> / Page : <%= gPage%>
		</td>
		<td align="right">
			Search : <input type="text" name="searchKw" size="25" value="<%= gKw%>"
				onkeypress="javascript:if(event.keyCode == 13){goSearch(); return;}">
		</td>
	</tr>
</table>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="100">&nbsp;Time</td>
		<td width="200">Username</td>
		<td width="200">Email</td>
		<td width="200">User Number</td>
		<td width="200">Type</td>
		<td width=""></td>
		<td width="150"></td>
	</tr>

<%
List<SignupRequestData> dataList = dao.selectList();
if(dataList.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='7' align='center'>No data</td>");
	out.println("</tr>");
}

for(int i = 0; i < dataList.size(); i++){
	SignupRequestData data = dataList.get(i);

	String typeStr = "Business";
	if(data.type == OperatorData.TYPE_HOME){
		typeStr = "Home";
	}

	if(i > 0){
		out.println("<tr class='line'><td colspan='7'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= data.getCtime()%></td>
		<td><%= data.username%></td>
		<td><%= data.email%></td>
		<td><%= data.userNum%></td>
		<td><%= typeStr%></td>
		<td></td>
		<td align="right">
		<%if(!data.approvedFlag){%>
			<input type="button" value="APPROVE" onclick="javascript:actionApprove(<%= data.id%>, '<%= data.username%>')">
			<input type="button" value="DEL" onclick="javascript:actionDelete(<%= data.id%>, '<%= data.username%>')">
		<%}%>
		</td>
	</tr>
<%}%>

	<tr class="line"><td colspan="7"></td></tr>
</table>
<!-- /list -->

<!-- pagination -->
<table width="100%">
	<tr>
		<td width="50%">
		</td>
		<td align="right">
			<div class="pagination"> 
				<%= getPagination2(gCount, gLimit, gPage)%>
			</div> 
		</td>
	</tr>
</table>
<!-- /pagination -->

<!-- goForm -->
<form action="<%= getPageName()%>" name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="page" value="<%= gPage%>">
<input type="hidden" name="kw" value="<%= gKw%>">
<input type="hidden" name="id" value="">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>
