<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
PolicyDao dao = new PolicyDao();

// Global.
PolicyData data = dao.selectOne(paramInt("id"));
%>

<!-- view -->
<fieldset>
<legend>POLICY</legend>
<table class="view">

	<tr>
		<td width="200">Name</td>
		<td><%= data.name%></td>
	</tr>

	<tr>
		<td>Description</td>
		<td>
			<input type="text" name="description" value="<%= data.description%>" size="50">
		</td>
	</tr>

	<tr>
		<td>Enable Filter</td>
		<td><input type="checkbox" class="no-border" name="enableFilter"
			<%if(data.enableFilter){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Block All</td>
		<td><input type="checkbox" class="no-border" name="blockAll" <%if(data.blockAll){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Block Unclassified</td>
		<td><input type="checkbox" class="no-border" name="blockUnclass" <%if(data.blockUnclass){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Safe-search</td>
		<td>
			<input type="radio" class="no-border" name="safeMode" value="0" <%if(data.safeMode == 0){out.print("checked");}%>> Off
			<input type="radio" class="no-border" name="safeMode" value="1" <%if(data.safeMode == 1){out.print("checked");}%>> Moderate
			<input type="radio" class="no-border" name="safeMode" value="2" <%if(data.safeMode == 2){out.print("checked");}%>> Strict
			<input type="checkbox" name="safeModeWithoutYoutube" <%if(data.safeModeWithoutYoutube){out.print("checked");}%>> Without Youtube
		</td>
	</tr>

	<tr>
		<td>Block-time</td>
		<td>
		
<%
List<String> hhList = getHhList();
List<String> mmList = getMmList();
%>
<select name="stimeHh">
<%
for(String hh : hhList){
	if(data.btStime.startsWith(hh)){
		printf("<option value='%s' selected>%s", hh, hh);
	}
	else{
		printf("<option value='%s'>%s", hh, hh);
	}
}
%>
</select>

<select name="stimeMm">
<%
for(String mm : mmList){
	if(data.btStime.endsWith(mm)){
		printf("<option value='%s' selected>%s", mm, mm);
	}
	else{
		printf("<option value='%s'>%s", mm, mm);
	}
}
%>
</select>
 ~
<select name="etimeHh">
<%
for(String hh : hhList){
	if(data.btEtime.startsWith(hh)){
		printf("<option value='%s' selected>%s", hh, hh);
	}
	else{
		printf("<option value='%s'>%s", hh, hh);
	}
}
%>
</select>

<select name="etimeMm">
<%
for(String mm : mmList){
	if(data.btEtime.endsWith(mm)){
		printf("<option value='%s' selected>%s", mm, mm);
	}
	else{
		printf("<option value='%s'>%s", mm, mm);
	}
}
%>
</select>
		
		</td>
	</tr>

	<tr>
		<td>Logging Only</td>
		<td><input type="checkbox" class="no-border" name="logOnly" <%if(data.logOnly){out.print("checked");}%>></td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
<legend>BLOCKED CATEGORIES</legend>
<table class="view">

	<tr>
		<td>
<%
for(int i = 0; i < data.blockCategoryList.size(); i++){
	CategoryData cd = data.blockCategoryList.get(i);

	String chkLine = "";
	if(cd.checkFlag){
		chkLine = "checked";
	}

	if(i > 0 && i % 5 == 0){
		out.println("<br>");
	}
%>
			<span class="category-item">
				<input type="checkbox" class="no-border"
					name="blockCategoryArr" value="<%= cd.id%>" <%= chkLine%>><%= cd.name%>
			</span>
<%}%>

		</td>
	</tr>

</table>
</fieldset>
<!-- /view -->

<%@include file="include/footer.jsp"%>
