<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void resetOpReqCnt(OperatorDao dao){
	if(dao.resetOpReqCnt(paramString("name"))){
		succList.add("Operator request count reset.");
	}
}

//-----------------------------------------------
void update(OperatorDao dao){
	// Get old data.
	OperatorData data = dao.selectOne(paramInt("id"));

	// Replace some values.
	data.id = paramInt("id");
	data.name = paramString("name");
	data.description = paramString("description");
	data.passwd = paramString("passwd");

	data.maxUser = paramInt("maxUser");
	data.maxUserIp = paramInt("maxUserIp");
	data.maxPolicy = paramInt("maxPolicy");
	data.maxWhitelist = paramInt("maxWhitelist");
	data.maxFreeTime = paramInt("maxFreeTime");

	data.email = paramString("email");
	data.alertPeriod = paramInt("alertPeriod");
	data.type = paramInt("type");
	data.stopFlag = paramBoolean("stopFlag");
	data.expDate = paramString("expDate");

	data.trialFlag = paramBoolean("trialFlag");

	// Preventing reset alert category.
	data.alertCategoryArr = null;

	// Param validation.
	if (data.alertPeriod > 0 && !isValidEmail(data.email)) {
		errList.add("Invalid email address.");
		return;
	}

	if(data.trialFlag && dao.isOpTrialLicenseExpired(data.id)){
		errList.add("Trial license has already expired!");
		return;
	}

	boolean resFlag = dao.update(data);

	OperatorData data2 = dao.selectOne(paramInt("id"));
	if(!data.stopFlag && data2.stopFlag){
		errList.add("Operator has been suspended for having too many users.");
		return;
	}

	if(resFlag){
		succList.add("Update finished.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Check refresh without id.
if(!checkEditId("operator,operator.jsp")){
	return;
}

// Create data access object.
OperatorDao dao = new OperatorDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("resetOpReqCnt")){
	resetOpReqCnt(dao);
}

// Global.
int gOpId = paramInt("id");

// Operator data.
OperatorData data = dao.selectOne(gOpId);

// Get user list.
UserDao userDao = new UserDao(gOpId);
userDao.limit = 1000;
List<UserData> gUserList = userDao.selectList();

// Get policy list.
List<PolicyData> gPolicyList = new PolicyDao(gOpId).selectList();

// Get whitelist list.
List<WhitelistData> gWhitelist = new WhitelistDomainDao(gOpId).selectList();

// Get free-time list.
List<FreeTimeData> gFreeTimeList = new FreeTimeDao(gOpId).selectList();

// Operator request count from in-memory map.
int gOpReqCnt = dao.getOpReqCnt(data.name);
int gOpMaxReqCnt = dao.calcOpMaxReqCnt(data.maxUser, data.type);
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionResetOpReqCnt(){
	if(!confirm("Reset operator request count : <%= data.name%>")){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "resetOpReqCnt";
	form.id.value = <%= data.id%>;
	form.name.value = "<%= data.name%>";
	form.submit();
}

//-----------------------------------------------
function update(form){
	form.actionFlag.value = "update";
	form.submit();
}

//-----------------------------------------------
function goTestUser(name){
	var form = document.goForm;
	form.action = "operator,user_test.jsp";
	form.mode.value = 'test';
	form.name.value = name;
	form.submit();
}

//-----------------------------------------------
function goPolicyEdit(id){
	var form = document.goForm;
	form.action = "operator,policy_edit.jsp";
	form.mode.value = "edit";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
function goPolicyNxProxy(opId, opName){
	var form = document.goForm;
	form.action = "operator,policy,nxproxy.jsp";
	form.opId.value = opId;
	form.opName.value = opName;
	form.submit();
}

//-----------------------------------------------
function goPolicyCxBlock(opId, opName){
	var form = document.goForm;
	form.action = "operator,policy,cxblock.jsp";
	form.opId.value = opId;
	form.opName.value = opName;
	form.submit();
}

//-----------------------------------------------
function goUserEdit(id){
	var form = document.goForm;
	form.action = "operator,user_edit.jsp";
	form.id.value = id;
	form.submit();
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">
<input type="hidden" name="id" value="<%= paramInt("id")%>">

<!--  -->
<fieldset>
<legend>OPERATOR</legend>
<table class="view">

	<tr>
		<td width="200">Name</td>
		<td>
			<%= data.name%>
		</td>
	</tr>

	<tr>
		<td>Password</td>
		<td><input type="password" name="passwd" size="50" maxlength="16" value="<%= data.passwd%>"></td>
	</tr>

	<tr>
		<td>Max User</td>
		<td><%= data.userCnt%> / <input type="text" name="maxUser" value="<%= data.maxUser%>" size="3"></td>
	</tr>

	<tr>
		<td>Max User IP</td>
		<td><%= data.userIpCnt%> / <input type="text" name="maxUserIp" value="<%= data.maxUserIp%>" size="3"></td>
	</tr>

	<tr>
		<td>Max Policy</td>
		<td><%= data.policyCnt%> / <input type="text" name="maxPolicy" value="<%= data.maxPolicy%>" size="3"></td>
	</tr>

	<tr>
		<td>Max Whitelist</td>
		<td><%= data.whitelistCnt%> / <input type="text" name="maxWhitelist" value="<%= data.maxWhitelist%>" size="3"></td>
	</tr>

	<tr>
		<td>Max Free-time</td>
		<td><%= data.freeTimeCnt%> / <input type="text" name="maxFreeTime" value="<%= data.maxFreeTime%>" size="3"></td>
	</tr>

	<tr>
		<td>Alert Email</td>
		<td><input type="text" name="email" value="<%= data.email%>" size="50"></td>
	</tr>

	<tr>
		<td>Alert Period</td>
		<td>
<select name="alertPeriod">
<%
Map<Integer, String> periodMap = getAlertPeriodMap();
for(Map.Entry<Integer, String> entry : periodMap.entrySet()){
	Integer key = entry.getKey();
	String val = entry.getValue();

	if(key == data.alertPeriod){
		printf("<option value='%s' selected>%s", key, val);
	}
	else{
		printf("<option value='%s'>%s", key, val);
	}
}
%>
</select>
		</td>
	</tr>

	<tr>
		<td>Expiration Date</td>
		<td>
		<input id="expDate" type="text" name="expDate" value="<%= data.getExpDate()%>" size="8">
		<input type="button" value="CLEAR" onclick="javascript:this.form.expDate.value='';">
		</td>
	</tr>

	<tr>
		<td>Description</td>
		<td><input type="text" name="description" size="50" value="<%= data.description%>"></td>
	</tr>

	<tr>
		<td>Type</td>
		<td>
			<input type="radio" class="no-border" name="type" value="1"
				<%if(data.type == OperatorData.TYPE_BUSINESS){out.print("checked");}%>> Business
			<input type="radio" class="no-border" name="type" value="2"
				<%if(data.type == OperatorData.TYPE_HOME){out.print("checked");}%>> Home
		</td>
	</tr>

	<tr>
		<td>Suspend</td>
		<td><input type="checkbox" class="no-border"
			name="stopFlag" <%if(data.stopFlag){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Request Count</td>
		<td>
			<%= gOpReqCnt%> / <%= gOpMaxReqCnt%>&nbsp;
			<input type="button" value="RESET COUNT" onclick="javascript:actionResetOpReqCnt()">
		</td>
	</tr>

	<tr>
		<td>
			Trial Account
			<i class="fa fa-question-circle south-east" title="Trial account will be suspended after 30 days from its creation date.<br>
				You only can make it a trial account within 30 days from its creation date."></i>
		</td>
		<td>
			<input type="checkbox" class="no-border"
				name="trialFlag" <%if(data.trialFlag){out.print("checked");}%>>
				Created at <%= data.getCreationDate()%>, <%= data.getTrialDaysLeft()%> days left for trial
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:update(this.form);">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<!-- userList -->
<div class="table-title">USER</div>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="200">&nbsp;Name</td>
		<td width="200">IP</td>
		<td width="200">Work-time Policy</td>
		<td width="200">Free-time Policy</td>
		<td width="">Description</td>
		<td width="150"></td>
	</tr>

<%
if(gUserList.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='6' align='center'>No data</td>");
	out.println("</tr>");
}

for(int i = 0; i < gUserList.size(); i++){
	UserData dx = gUserList.get(i);

	String name = dx.name;
	if(dx.systemFlag){
		name = "*" + name;
	}

	String ipLine = dx.getIpLine();
	if(ipLine.length() > 30){
		ipLine = ipLine.substring(0, 30) + "..";
	}

	if(ipLine.length() == 0){
		ipLine = "Dynamic";
	}

	if(i > 0){
		out.println("<tr class='line'><td colspan='6'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= name%></td>
		<td><%= ipLine%></td>
		<td><%= dx.policyName%></td>
		<td><%= dx.ftPolicyName%></td>
		<td><%= dx.description%></td>
		<td align="right">
			<input type="button" value="TEST" onclick="javascript:goTestUser('<%= dx.name%>')">
			<input type="button" value="VIEW" onclick="javascript:goUserEdit(<%= dx.id%>)">
		</td>
	</tr>
<%}%>

	<tr class="line"><td colspan="6"></td></tr>
</table>
<!-- /userList -->

<!-- policyList -->
<div class="table-title">POLICY</div>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="200">&nbsp;Name</td>
		<td width="">Description</td>
		<td width="150"></td>
	</tr>

<%
if(gPolicyList.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='3' align='center'>No data</td>");
	out.println("</tr>");
}

for(int i = 0; i < gPolicyList.size(); i++){
	PolicyData dx = gPolicyList.get(i);

	String name = dx.name;
	if(dx.systemFlag){
		name = "*" + name;
	}

	if(i > 0){
		out.println("<tr class='line'><td colspan='3'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= name%></td>
		<td><%= dx.description%></td>
		<td align="right">
			<input type="button" value="VIEW" onclick="javascript:goPolicyEdit(<%= dx.id%>)">
		</td>
	</tr>
<%}%>

	<tr class="line"><td colspan="3"></td></tr>
</table>
<!-- /policyList -->

<input type="button" value="VIEW NXPROXY POLICY" onclick="javascript:goPolicyNxProxy(<%= gOpId%>, '<%= data.name%>')" style="margin-top: 2px;">

<!-- whitelist -->
<div class="table-title">WHITELIST</div>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="200">&nbsp;Domain</td>
		<td width="400">Flags</td>
		<td width="500">Applied Policy</td>
		<td width=""></td>
	</tr>

<%
if(gWhitelist.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='4' align='center'>No data</td>");
	out.println("</tr>");
}

for(int i = 0; i < gWhitelist.size(); i++){
	WhitelistData dx = gWhitelist.get(i);

	if(i > 0){
		out.println("<tr class='line'><td colspan='4'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= dx.domain%></td>
		<td><%= dx.getFlagLine()%></td>
		<td><%= dx.getAppliedPolicyLine()%></td>
		<td></td>
	</tr>
<%}%>

	<tr class="line"><td colspan="4"></td></tr>
</table>
<!-- /whitelist -->

<!-- freeTimeList -->
<div class="table-title">FREE TIME</div>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="200">&nbsp;Time</td>
		<td width="300">Day of Week</td>
		<td width="">Description</td>
	</tr>

<%
if(gFreeTimeList.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='3' align='center'>No data</td>");
	out.println("</tr>");
}

for(int i = 0; i < gFreeTimeList.size(); i++){
	FreeTimeData dx = gFreeTimeList.get(i);

	if(i > 0){
		out.println("<tr class='line'><td colspan='3'></td></tr>");
	}
%>
	<tr class="row">
		<td><%= dx.stime%> ~ <%= dx.etime%></td>
		<td><%= dx.getWdayLine()%></td>
		<td><%= dx.description%></td>
	</tr>
<%}%>

	<tr class="line"><td colspan="3"></td></tr>
</table>
<!-- /freeTimeList -->

<!-- goForm -->
<form action="" name="goForm" method="get">
<input type="hidden" name="mode" value="">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="">
<input type="hidden" name="name" value="">
<input type="hidden" name="opId" value="">
<input type="hidden" name="opName" value="">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>

<!-- Datetime picker -->
<script type="text/javascript">
//-----------------------------------------------
var dateToDisable = new Date();

//-----------------------------------------------
jQuery("#expDate").datetimepicker({
	format: "<%= getGuiDateFormatForPicker()%>",
	step: 1,
	timepicker: false,
	beforeShowDay: function(date) {
		if (date.getTime() < dateToDisable.getTime()) {
			return [false, ""]
		}

		return [true, ""];
	}
});
</script>
