<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void insert(OperatorDao dao){
	OperatorData data = new OperatorData();
	data.name = paramString("name");
	data.type = paramInt("type");
	data.description = paramString("description");
	
	// We use name of the user as the initial password.
	data.passwd = paramString("name");

	// Set default value.
	LicensePolicyData lpData = new LicensePolicyDao().selectOne();
	data.maxUser = lpData.maxUser;
	data.maxUserIp = lpData.maxUserIp;
	data.maxPolicy = lpData.maxPolicy;
	data.maxWhitelist = lpData.maxWhitelist;
	data.maxFreeTime = lpData.maxFreeTime;

	// Default value for home operator.
	if(data.type == OperatorData.TYPE_HOME){
		data.maxUser = 1;
	}

	// Param validation.
	if(!ParamTest.isValidNameLen(data.name)){
		errList.add(ParamTest.ERR_NAME_LEN);
		return;
	}
	
	if(!ParamTest.isValidUsernameChar(data.name)){
		errList.add(ParamTest.ERR_USERNAME_CHAR);
		return;
	}

	if (ParamTest.isDupOperator(data.name)) {
		errList.add("Operator already exists.");
		return;
	}

	if (ParamTest.isDupUser(data.name)) {
		errList.add("User already exists.");
		return;
	}

	if(ParamTest.testMaxLicenseUser(data.maxUser)){
		errList.add("Can't add more user.");
		return;
	}

	if(dao.insert(data)){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void delete(OperatorDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	if(dao.delete(paramInt("id"))){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
OperatorDao dao = new OperatorDao();
dao.page = paramInt("page", 1);
dao.addKw(paramString("kw"));

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("insert")){
	insert(dao);
}
if(actionFlag.equals("delete")){
	delete(dao);
}

// Global.
int gCount = dao.selectCount();
int gTrialCount = dao.selectTrialCount();
int gSuspendedCount = dao.selectSuspendedCount();
int gPage = dao.page;
int gLimit = dao.limit;
String gKw = paramString("kw");

OperatorData sumData = dao.selectSum();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionDelete(id, name){
	if(!confirm("Deleting operator : " + name)){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "delete";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
function goPage(page){
	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.page.value = page;
	form.submit();
}

//-----------------------------------------------
function goSearch(kw){
	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.kw.value = document.all("searchKw").value;
	form.page.value = "1";
	form.submit();
}

//-----------------------------------------------
function goEdit(id){
	var form = document.goForm;
	form.action = "operator,operator_edit.jsp";
	form.id.value = id;
	form.submit();
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="insert">

<fieldset>
	<legend>OPERATOR</legend>
<table class="view">

	<tr>
		<td width="200">Name</td>
		<td>
			<input type="text" name="name" size="50">
		</td>
	</tr>

	<tr>
		<td>Description</td>
		<td>
			<input type="text" name="description" size="50">
		</td>
	</tr>

	<tr>
		<td>Type</td>
		<td>
			<input type="radio" class="no-border" name="type" value="1" checked> Business
			<input type="radio" class="no-border" name="type" value="2"> Home
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<!-- list -->
<table width="100%" class="with-top-margin">
	<tr>
		<td width="50%">
			Count : <%= gCount%> / Page : <%= gPage%>
		</td>
		<td align="right">
			Search : <input type="text" name="searchKw" size="25" value="<%= gKw%>"
				onkeypress="javascript:if(event.keyCode == 13){goSearch(); return;}">
		</td>
	</tr>
</table>

<table width="100%" cellpadding="0" cellspacing="0">
	<tr class="list-head">
		<td width="200">&nbsp;Name</td>
		<td width="140">User</td>
		<td width="140">User IP</td>
		<td width="140">Policy</td>
		<td width="140">Whitelist</td>
		<td width="140">Free-time</td>
		<td width="140">Expiration Date</td>
		<td width="140">Type</td>
		<td width="">Description</td>
		<td width="150"></td>
	</tr>

	<tr class="row">
		<td>*Sum</td>
		<!-- sumData.maxUserActive = Sum of the max user numbers from the active or not suspended operators -->
		<td>
			<%= sumData.userCnt%>/ <%= sumData.maxUser%> / <%= sumData.maxUserActive%> / <%= sumData.maxUserTrial%>&nbsp;
			<i class="fa fa-question-circle south-east" title="The number of users created by all operators
				<br>/ The number of users allocated to all operators
				<br>/ The number of users allocated to all active (not suspended) operators
				<br>/ The number of users allocated to all trial operators
			"></i>
		</td>
		<td>
			<%= sumData.userIpCnt%> / <%= sumData.maxUserIp%>&nbsp;
			<i class="fa fa-question-circle south-east" title="The number of IPs associated by all operators
				<br>/ The number of IPs that can be associated by all operators
			"></i>
		</td>
		<td>
			<%= sumData.policyCnt%>  / <%= sumData.maxPolicy%>&nbsp;
			<i class="fa fa-question-circle south-east" title="The number of policies created by all operators
				<br>/ The number of policies that can be created by all operators
			"></i>
		</td>
		<td>
			<%= sumData.whitelistCnt%>  / <%= sumData.maxWhitelist%>&nbsp;
			<i class="fa fa-question-circle south-east" title="The number of whitelist data created by all operators
				<br>/ The number of whitelist data that can be created by all operators
			"></i>
		</td>
		<td>
			<%= sumData.freeTimeCnt%>  / <%= sumData.maxFreeTime%>&nbsp;
			<i class="fa fa-question-circle south-east" title="The number of free time data created by all operators
				<br>/ The number of free time data that can be created by all operators
			"></i>
		</td>
		<td></td>
		<td></td>
		<td></td>
	</tr>
	<tr class="line"><td colspan="10"></td></tr>

<%
List<OperatorData> dataList = dao.selectList();
if(dataList.isEmpty()){
	out.println("<tr class='row'>");
	out.println("<td colspan='10' align='center'>No data</td>");
	out.println("</tr>");
}

for(int i = 0; i < dataList.size(); i++){
	OperatorData data = dataList.get(i);

	String nameStyle = "";
	if(data.stopFlag || data.isExpired()){
		nameStyle = "text-decoration:line-through;";
	}

	String typeStr = "Business";
	if(data.type == OperatorData.TYPE_HOME){
		typeStr = "Home";
	}

	String showTrial = "";
	if(data.trialFlag){
		showTrial = " - T";
	}

	if(i > 0){
		out.println("<tr class='line'><td colspan='10'></td></tr>");
	}
%>
	<tr class="row">
		<td style="<%= nameStyle%>"><%= data.name%><%= showTrial%></td>
		<td><%= data.userCnt%> / <%= data.maxUser%></td>
		<td><%= data.userIpCnt%> / <%= data.maxUserIp%></td>
		<td><%= data.policyCnt%>  / <%= data.maxPolicy%></td>
		<td><%= data.whitelistCnt%>  / <%= data.maxWhitelist%></td>
		<td><%= data.freeTimeCnt%>  / <%= data.maxFreeTime%></td>
		<td><%= data.getExpDate()%></td>
		<td><%= typeStr%></td>
		<td><%= data.description%></td>
		<td align="right">
			<input type="button" value="EDIT" onclick="javascript:goEdit(<%= data.id%>)">
			<input type="button" value="DEL" onclick="javascript:actionDelete(<%= data.id%>, '<%= data.name%>')">
		</td>
	</tr>
<%}%>

	<tr class="line"><td colspan="10"></td></tr>
</table>
<!-- /list -->

<!-- pagination -->
<table width="100%">
	<tr>
		<td width="50%">
		* Trial = <%= gTrialCount%>, Suspended = <%= gSuspendedCount%>
		</td>
		<td align="right">
			<div class="pagination"> 
				<%= getPagination2(gCount, gLimit, gPage)%>
			</div> 
		</td>
	</tr>
</table>
<!-- /pagination -->

<!-- goForm -->
<form action="<%= getPageName()%>" name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="page" value="<%= gPage%>">
<input type="hidden" name="kw" value="<%= gKw%>">
<input type="hidden" name="id" value="">
<input type="hidden" name="name" value="">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>
