<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(LicensePolicyDao dao){
	LicensePolicyData data = new LicensePolicyData();

	data.onLicenseViolation = paramInt("onLicenseViolation");
	data.beforeLicenseExpiration = paramInt("beforeLicenseExpiration");
	data.onTrialExpiration = paramInt("onTrialExpiration");
	data.useTrialPeriod = paramBoolean("useTrialPeriod");
	data.onSignupRequest = paramInt("onSignupRequest");
	data.onSignupApproval = paramInt("onSignupApproval");

	data.maxUser = paramInt("maxUser");
	data.maxUserIp = paramInt("maxUserIp");
	data.maxPolicy = paramInt("maxPolicy");
	data.maxWhitelist = paramInt("maxWhitelist");
	data.maxFreeTime = paramInt("maxFreeTime");

	// Update it.
	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
LicensePolicyDao dao = new LicensePolicyDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
LicensePolicyData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionTest(form){
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "test";
	form.submit();
}
</script>

<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<!--  -->
<fieldset>
	<legend>LICENSE POLICY</legend>
<table class="view">

	<tr>
		<td width="200">
			On License Violation
			<i class="fa fa-question-circle south-east" title="When there is a 'Too many requests' license violation for an operator,
				<br>you can bypass filtering or just send a warning email for that."></i>
		</td>
		<td>
			<input type="radio" class="no-border" name="onLicenseViolation" value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
				<%if(data.onLicenseViolation == LicensePolicyData.ACTION_DO_NOTHING){out.print("checked");}%>> Do nothing
			<input type="radio" class="no-border" name="onLicenseViolation" value="<%= LicensePolicyData.ACTION_SEND_EMAIL%>"
				<%if(data.onLicenseViolation == LicensePolicyData.ACTION_SEND_EMAIL){out.print("checked");}%>> Warning email
			<input type="radio" class="no-border" name="onLicenseViolation" value="<%= LicensePolicyData.ACTION_BYPASS_FILTER%>"
				<%if(data.onLicenseViolation == LicensePolicyData.ACTION_BYPASS_FILTER){out.print("checked");}%>> Bypass filtering
		</td>
	</tr>

	<tr>
		<td>
			Before License Expiration
			<i class="fa fa-question-circle south-east" title="You can send warning emails to your operators before their license expired.
				<br>The warning emails will be sent on 15, 12, 9, 6, 3 days before the expiration date."></i>
		</td>
		<td>
			<input type="radio" class="no-border" name="beforeLicenseExpiration" value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
				<%if(data.beforeLicenseExpiration == LicensePolicyData.ACTION_DO_NOTHING){out.print("checked");}%>> Do nothing
			<input type="radio" class="no-border" name="beforeLicenseExpiration" value="<%= LicensePolicyData.ACTION_SEND_EMAIL%>"
				<%if(data.beforeLicenseExpiration == LicensePolicyData.ACTION_SEND_EMAIL){out.print("checked");}%>> Warning email
		</td>
	</tr>

	<tr>
		<td>
			On Trial Expiration
			<i class="fa fa-question-circle south-east" title="You can suspend an operator account when his/her trial period expires.
			<br>When you suspend an oprator account, all the requests from the operator will be blocked."></i>
		</td>
		<td>
			<input type="radio" class="no-border" name="onTrialExpiration" value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
				<%if(data.onTrialExpiration == LicensePolicyData.ACTION_DO_NOTHING){out.print("checked");}%>> Do nothing
			<input type="radio" class="no-border" name="onTrialExpiration" value="<%= LicensePolicyData.ACTION_SUSPEND_ACCT%>"
				<%if(data.onTrialExpiration == LicensePolicyData.ACTION_SUSPEND_ACCT){out.print("checked");}%>> Suspend
		</td>
	</tr>

	<tr>
		<td>
			Use Trial Period
			<i class="fa fa-question-circle south-east" title="With this option enabled, a new operator will be in 30 days trial period."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="useTrialPeriod" <%if(data.useTrialPeriod){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			On Signup Request
			<i class="fa fa-question-circle south-east" title="If you don't need the approval process for a signup request and want to create operators
			<br>at their signup time automatically, select 'Create a new operator'."></i>
		</td>
		<td>
			<input type="radio" class="no-border" name="onSignupRequest" value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
				<%if(data.onSignupRequest == LicensePolicyData.ACTION_DO_NOTHING){out.print("checked");}%>> Do nothing
			<input type="radio" class="no-border" name="onSignupRequest" value="<%= LicensePolicyData.ACTION_CREATE_OPERATOR%>"
				<%if(data.onSignupRequest == LicensePolicyData.ACTION_CREATE_OPERATOR){out.print("checked");}%>> Create a new operator
		</td>
	</tr>

	<tr>
		<td>
			On Signup Approval
			<i class="fa fa-question-circle south-east" title="You can send a notification email to new operators for when their signup requests approved."></i>
		</td>
		<td>
			<input type="radio" class="no-border" name="onSignupApproval" value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
				<%if(data.onSignupApproval == LicensePolicyData.ACTION_DO_NOTHING){out.print("checked");}%>> Do nothing
			<input type="radio" class="no-border" name="onSignupApproval" value="<%= LicensePolicyData.ACTION_SEND_EMAIL%>"
				<%if(data.onSignupApproval == LicensePolicyData.ACTION_SEND_EMAIL){out.print("checked");}%>> Notification email
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
<legend>OPERATOR DEFAULT</legend>
<table class="view">

	<tr>
		<td width="200">
			Max User
		</td>
		<td><input type="text" name="maxUser" size="2"
			value="<%= data.maxUser%>" size="3"></td>
	</tr>

	<tr>
		<td>Max User IP</td>
		<td><input type="text" name="maxUserIp" size="2" maxlength="3"
			value="<%= data.maxUserIp%>"></td>
	</tr>

	<tr>
		<td>Max Policy</td>
		<td><input type="text" name="maxPolicy" size="2" maxlength="3"
			value="<%= data.maxPolicy%>"></td>
	</tr>

	<tr>
		<td>Max Whitelist</td>
		<td><input type="text" name="maxWhitelist" size="2" maxlength="3"
			value="<%= data.maxWhitelist%>"></td>
	</tr>

	<tr>
		<td>Max Free Time</td>
		<td><input type="text" name="maxFreeTime" size="2" maxlength="3"
			value="<%= data.maxFreeTime%>"></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>

<%@include file="include/footer.jsp"%>
