<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(PolicyDao dao){
	PolicyData data = new PolicyData();

	data.id = paramInt("id");
	data.points = paramInt("points");
	data.description = paramString("description");
	data.enableFilter = paramBoolean("enableFilter");

	data.blockAll = paramBoolean("blockAll");
	data.blockUnclass = paramBoolean("blockUnclass");
//	data.adRemove = paramBoolean("adRemove");
//	data.maxDomainLen = paramInt("maxDomainLen");

//	data.blockCovertChan = paramBoolean("blockCovertChan");
//	data.blockMailerWorm = paramBoolean("blockMailerWorm");
//	data.aRecordOnly = paramBoolean("aRecordOnly");

	data.safeMode = paramInt("safeMode");
	data.safeModeWithoutYoutube = paramBoolean("safeModeWithoutYoutube");
	data.logOnly = paramBoolean("logOnly");
	data.blockCategoryArr = paramArray("blockCategoryArr");

	String stimeHh = paramString("stimeHh");
	String stimeMm = paramString("stimeMm");
	String etimeHh = paramString("etimeHh");
	String etimeMm = paramString("etimeMm");

	data.btStime = stimeHh + stimeMm;
	data.btEtime = etimeHh + etimeMm;

	if(dao.updatePolicyTemplate(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
PolicyDao dao = new PolicyDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
PolicyData data = dao.selectGlobal();
%>
<%@include file="include/action_info.jsp"%>

<!-- view -->
<form action="<%= getPageName()%>" method="post" name="policy_form">
<input type="hidden" name="actionFlag" value="update">
<input type="hidden" name="id" value="<%= data.id%>">

<!--  -->
<fieldset>
<legend>DEFAULT POLICY</legend>
<table class="view">

	<tr>
		<td colspan="2">
			<div style="line-height:20px;">
				This is the template for operator policies. New policies by operators will be created based on this template.
			</div>
		</td>
	</tr>

	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>

	<tr>
		<td width="200">Block All</td>
		<td><input type="checkbox" class="no-border" name="blockAll" <%if(data.blockAll){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Block Unclassified</td>
		<td><input type="checkbox" class="no-border" name="blockUnclass" <%if(data.blockUnclass){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>Safe Search</td>
		<td>
			<input type="radio" class="no-border" name="safeMode" value="0" <%if(data.safeMode == 0){out.print("checked");}%>> Off
			<input type="radio" class="no-border" name="safeMode" value="1" <%if(data.safeMode == 1){out.print("checked");}%>> Moderate
			<input type="radio" class="no-border" name="safeMode" value="2" <%if(data.safeMode == 2){out.print("checked");}%>> Strict
			<input type="checkbox" name="safeModeWithoutYoutube" <%if(data.safeModeWithoutYoutube){out.print("checked");}%>> Without Youtube
		</td>
	</tr>

	<tr>
		<td>Block-time</td>
		<td>
		
<%
List<String> hhList = getHhList();
List<String> mmList = getMmList();
%>
<select name="stimeHh">
<%
for(String hh : hhList){
	if(data.btStime.startsWith(hh)){
		printf("<option value='%s' selected>%s", hh, hh);
	}
	else{
		printf("<option value='%s'>%s", hh, hh);
	}
}
%>
</select>

<select name="stimeMm">
<%
for(String mm : mmList){
	if(data.btStime.endsWith(mm)){
		printf("<option value='%s' selected>%s", mm, mm);
	}
	else{
		printf("<option value='%s'>%s", mm, mm);
	}
}
%>
</select>
 ~
<select name="etimeHh">
<%
for(String hh : hhList){
	if(data.btEtime.startsWith(hh)){
		printf("<option value='%s' selected>%s", hh, hh);
	}
	else{
		printf("<option value='%s'>%s", hh, hh);
	}
}
%>
</select>

<select name="etimeMm">
<%
for(String mm : mmList){
	if(data.btEtime.endsWith(mm)){
		printf("<option value='%s' selected>%s", mm, mm);
	}
	else{
		printf("<option value='%s'>%s", mm, mm);
	}
}
%>
</select>
		
		</td>
	</tr>

	<tr>
		<td>Logging Only</td>
		<td><input type="checkbox" class="no-border" name="logOnly" <%if(data.logOnly){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
<legend>BLOCKED CATEGORIES</legend>
<table class="view">

	<tr>
		<td colspan="2">

<%
for(int i = 0; i < data.blockCategoryList.size(); i++){
	CategoryData cd = data.blockCategoryList.get(i);

	String chkLine = "";
	if(cd.checkFlag){
		chkLine = "checked";
	}

	if(i > 0 && i % 5 == 0){
		out.println("<br>");
	}
%>
			<span class="category-item">
				<input type="checkbox" class="no-border"
					name="blockCategoryArr" value="<%= cd.id%>" <%= chkLine%>><%= cd.name%>
			</span>
<%}%>

		</td>
	</tr>

	<tr>
		<td width="200"></td>
		<td >
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
			<input type="button" value="TOGGLE-ALL" onclick="javascript:checkboxToggleAll3('blockCategoryArr');"><br>
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<%@include file="include/footer.jsp"%>
