<%@include file="../include/lib.jsp"%>
<%@page import="org.json.simple.*"%>
<%!
//-----------------------------------------------
boolean createOperator(String opName, int opType) throws Exception{
	OperatorData data = new OperatorData();
	data.name = opName;

	// Operator type.
	data.type = opType;  // 1 = Business, 2 = Home.
	if(opType < 1 || opType > 2){
		opType = 1;
	}
	
	// We use name of the user as the initial password.
	data.passwd = opName;

	// Set default value.
	data.maxUser = 3;
	data.maxUserIp = 3;
	data.maxPolicy = 3;
	data.maxWhitelist = 20;
	data.maxFreeTime = 5;

	// Default value for home operator.
	if(data.type == OperatorData.TYPE_HOME){
		data.maxUser = 1;
	}

	// Give 30 day trial.
	data.expDate = strftimeAdd("yyyyMMdd", 86400 * 30);

	// Param validation.
	if(!ParamTest.isValidNameLen(data.name)){
		throw new Exception(ParamTest.ERR_NAME_LEN);
	}
	
	if(!ParamTest.isValidUsernameChar(data.name)){
		throw new Exception(ParamTest.ERR_USERNAME_CHAR);
	}

	if (ParamTest.isDupOperator(data.name)) {
		throw new Exception("Operator already exists!");
	}

	if (ParamTest.isDupUser(data.name)) {
		throw new Exception("User already exists!");
	}

	if(ParamTest.testMaxLicenseUser(data.maxUser)){
		throw new Exception("Can't add more user!");
	}

	if(new OperatorDao().insert(data)){
		return true;
	}
	else{
		return false;
	}
}
%>
<%
// Only localhost access allowed.
if(!request.getRemoteAddr().startsWith("127.0.0.1")){
	out.println(request.getRemoteAddr());
	return;
}

// Get common params.
String action = paramString("action");
String opName = paramString("opName");

// Defined actions.
if(action.equals("createOperator") && isNotEmpty(opName)){
	int opType = paramInt("opType");

	try{
		if(createOperator(opName, opType)){
			out.print("/OK");
		}
		else{
			out.print("/ERR");
		}
	}
	catch(Exception e){
		out.print(e.toString());
	}
}
else if(action.equals("selectOperator") && isNotEmpty(opName)){
	OperatorData data = new OperatorDao().selectOneByName(opName);
	if(data == null){
		out.print("/ERR");
		return;
	}

	JSONObject obj = new JSONObject();
	obj.put("id", data.id);
	obj.put("name", data.name);
	obj.put("description", data.description);
	obj.put("stopFlag", data.stopFlag);
	obj.put("email", data.email);
	obj.put("alertPeriod", data.alertPeriod);
	obj.put("maxUser", data.maxUser);
	obj.put("maxUserIp", data.maxUserIp);
	obj.put("maxPolicy", data.maxPolicy);
	obj.put("maxWhitelist", data.maxWhitelist);
	obj.put("maxFreeTime", data.maxFreeTime);
	obj.put("userCnt", data.userCnt);
	obj.put("userIpCnt", data.userIpCnt);
	obj.put("policyCnt", data.policyCnt);
	obj.put("whitelistCnt", data.whitelistCnt);
	obj.put("freeTimeCnt", data.freeTimeCnt);
	obj.put("expDate", data.expDate);

	out.print(obj);
}
else if(action.equals("setExpDate") && isNotEmpty(opName)){
	OperatorDao dao = new OperatorDao();
	OperatorData data = dao.selectOneByName(opName);
	if(data == null){
		out.print("/ERR");
		return;
	}

	// Set expDate.
	data.expDate = paramString("expDate");
	if(stringToUnixTimestamp("yyyyMMdd", data.expDate) == 0){
		out.print("/ERR");
		return;
	}

	if(dao.update(data)){
		out.print("/OK");
	}
	else{
		out.print("/ERR");
	}
}
else if(action.equals("setPasswd") && isNotEmpty(opName)){
	OperatorDao dao = new OperatorDao();
	OperatorData data = dao.selectOneByName(opName);
	if(data == null){
		out.print("/ERR");
		return;
	}

	// Set passwd.
	data.passwd = paramString("passwd");

	if(dao.update(data)){
		out.print("/OK");
	}
	else{
		out.print("/ERR");
	}
}
%>