<%@include file="../include/lib.jsp"%>
<%@page import="org.json.simple.*"%>
<%!
//-----------------------------------------------
boolean createOperator(String opname, int optype) throws Exception{
	OperatorData data = new OperatorData();
	data.name = opname;

	// Operator type.
	data.type = optype;  // 1 = Business, 2 = Home.
	if(optype < 1 || optype > 2){
		optype = 1;
	}
	
	// We use name of the user as the initial password.
	data.passwd = opname;

	// Set default value.
	data.maxUser = 3;
	data.maxUserIp = 3;
	data.maxPolicy = 3;
	data.maxWhitelist = 20;
	data.maxFreeTime = 5;

	// Default value for home operator.
	if(data.type == OperatorData.TYPE_HOME){
		data.maxUser = 1;
	}

	// Param validation.
	if(!ParamTest.isValidNameLen(data.name)){
		throw new Exception(ParamTest.ERR_NAME_LEN);
	}
	
	if(!ParamTest.isValidUsernameChar(data.name)){
		throw new Exception(ParamTest.ERR_USERNAME_CHAR);
	}

	if (ParamTest.isDupOperator(data.name)) {
		throw new Exception("Operator already exists!");
	}

	if (ParamTest.isDupUser(data.name)) {
		throw new Exception("User already exists!");
	}

	if(ParamTest.testMaxLicenseUser(data.maxUser)){
		throw new Exception("Can't add more user!");
	}

	if(new OperatorDao().insert(data)){
		return true;
	}
	else{
		return false;
	}
}

//-----------------------------------------------
boolean createUser(String opname, String uname) throws Exception{
	UserData data = new UserData();
	data.name = uname;

	// Find the operator.
	OperatorData opData = new OperatorDao().selectOneByName(opname);
	if(opData == null){
		throw new Exception("Couldn't find the operator!");
	}

	// Param validation.
	if(!ParamTest.isValidNameLen(data.name)){
		throw new Exception(ParamTest.ERR_NAME_LEN);
	}
	
	if(!ParamTest.isValidUsernameChar(data.name)){
		throw new Exception(ParamTest.ERR_USERNAME_CHAR);
	}

	if (ParamTest.isDupUser(data.name, opData.id)) {
		throw new Exception("User already exists!");
	}

	if(ParamTest.hasMaxUserForOperator(opData.id)){
		throw new Exception("Can't add more user!");
	}

	UserDao dao = new UserDao(opData.id);
	if(dao.insert(data)){
		return true;
	}
	else{
		return false;
	}
}
%>
<%
// Only localhost access allowed.
if(!request.getRemoteAddr().startsWith("127.0.0.1")){
	out.println(request.getRemoteAddr());
	return;
}

// Get params.
String action = paramString("action");
String ip = paramString("ip");
String token = paramString("token");
String uname = paramString("uname");
String opname = paramString("opname");
int optype = paramInt("optype");

if(action.equals("ipupdate") && isValidIp(ip) && isNotEmpty(token)){
	UserLoginDao dao = new UserLoginDao(request);
	if(dao.createIpSessionByToken(ip, token)){
		out.print("Login success.");
	}
	else{
		out.print("Login error!");
	}
}
else if(action.equals("createOperator") && isNotEmpty(opname)){
	try{
		if(createOperator(opname, optype)){
			out.print("Operator added.");
		}
		else{
			out.print("Operator not added.");
		}
	}
	catch(Exception e){
		out.print(e.toString());
	}
}
else if(action.equals("selectOperator") && isNotEmpty(opname)){
	OperatorData data = new OperatorDao().selectOneByName(opname);
	if(data == null){
		out.print("Couldn't find the operator!");
		return;
	}

	JSONObject obj = new JSONObject();
	obj.put("id", data.id);
	obj.put("name", data.name);
	obj.put("description", data.description);
	obj.put("stopFlag", data.stopFlag);
	obj.put("email", data.email);
	obj.put("alertPeriod", data.alertPeriod);
	obj.put("maxUser", data.maxUser);
	obj.put("maxUserIp", data.maxUserIp);
	obj.put("maxPolicy", data.maxPolicy);
	obj.put("maxWhitelist", data.maxWhitelist);
	obj.put("maxFreeTime", data.maxFreeTime);
	obj.put("userCnt", data.userCnt);
	obj.put("userIpCnt", data.userIpCnt);
	obj.put("policyCnt", data.policyCnt);
	obj.put("whitelistCnt", data.whitelistCnt);
	obj.put("freeTimeCnt", data.freeTimeCnt);

	out.print(obj);
}
else if(action.equals("createUser") && isNotEmpty(opname) && isNotEmpty(uname)){
	try{
		if(createUser(opname, uname)){
			out.print("User added.");
		}
		else{
			out.print("User not added.");
		}
	}
	catch(Exception e){
		out.print(e.toString());
	}
}
else if(action.equals("selectUser") && isNotEmpty(opname) && isNotEmpty(uname)){
	OperatorData opData = new OperatorDao().selectOneByName(opname);
	if(opData == null){
		out.print("Couldn't find the operator!");
		return;
	}

	UserData data = new UserDao(opData.id).selectOneByName(uname);
	if(data == null){
		out.print("Couldn't find the user!");
		return;
	}

	JSONObject obj = new JSONObject();
	obj.put("name", data.name);
	obj.put("description", data.description);
	obj.put("token", data.token);
	obj.put("policyName", data.policyName);
	obj.put("ftPolicyName", data.ftPolicyName);
	obj.put("ipLine", data.getIpLine());

	out.print(obj);
}
%>