<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
boolean checkParam(DnsSetupData data){
	if (!ParamTest.isValidUpstreamDnsServer(data.upstreamDns1)) {
		errList.add("Invalid IP address for DNS server #1.");
		return false;
	}

	if (isNotEmpty(data.upstreamDns2) && !ParamTest.isValidUpstreamDnsServer(data.upstreamDns2)) {
		errList.add("Invalid IP address for DNS server #2.");
		return false;
	}

	if (isNotEmpty(data.upstreamDns3) && !ParamTest.isValidUpstreamDnsServer(data.upstreamDns3)) {
	    errList.add("Invalid IP address for DNS server #3.");
	    return false;
	}

	return true;
}

//-----------------------------------------------
void update(DnsSetupDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	DnsSetupData data = dao.selectOne();

	// DNS setup.	
	data.upstreamDns1 = paramString("upstreamDns1");
    data.upstreamDns2 = paramString("upstreamDns2");
    data.upstreamDns3 = paramString("upstreamDns3");
    data.upstreamTimeout = paramInt("upstreamTimeout");
    data.respCacheSize = paramInt("respCacheSize");
	data.usePersistentCache = paramBoolean("usePersistentCache");
	data.useNegativeCache = paramBoolean("useNegativeCache");
	data.minimalResponses = paramBoolean("minimalResponses");

    data.minCacheTtl = paramInt("minCacheTtl");
    data.blockCacheTtl = paramInt("blockCacheTtl");

	// Validate and update it.
	if(checkParam(data) && dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
DnsSetupDao dao = new DnsSetupDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
DnsSetupData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>

<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<!--  -->
<fieldset>
<legend>DNS SETUP</legend>
<table width="100%" class="view">

	<tr>
		<td width="200">Upstream DNS Server #1</td>
		<td><input type="text" name="upstreamDns1" value="<%= data.upstreamDns1%>" size="50"></td>
	</tr>
	
	<tr>
		<td>Upstream DNS Server #2</td>
		<td><input type="text" name="upstreamDns2" value="<%= data.upstreamDns2%>" size="50"></td>
	</tr>

	<tr>
		<td>Upstream DNS Server #3</td>
		<td><input type="text" name="upstreamDns3" value="<%= data.upstreamDns3%>" size="50"></td>
	</tr>
	
	<tr>
		<td>Upstream DNS Query Timeout</td>
		<td><input type="text" name="upstreamTimeout" size="2" maxlength="2" value="<%= data.upstreamTimeout%>"> seconds, 1 ~ 20</td>
	</tr>

<%
DecimalFormat dfmt = new DecimalFormat("###,###");
String size1 = dfmt.format(data.inMemoryCacheSize);
String size2 = dfmt.format(data.persistentCacheSize);
String size3 = dfmt.format(data.negativeCacheSize);
%>
	<tr>
		<td>Response Cache Size</td>
		<td><input type="text" name="respCacheSize" size="7" maxlength="8"
			value="<%= data.respCacheSize%>"> 100,000 ~ 10,000,000<br>
			Current Size : In-memory = <%= size1%> / Persistent = <%= size2%> / Negative = <%= size3%>
		</td>
	</tr>

	<tr>
		<td>
			Use Persistent Cache
			<i class="fa fa-question-circle south-east" title="Keeping the DNS cache in DB. When there's an upstream DNS server failure
				<br>NxFilter uses its permanent cache."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="usePersistentCache" <%if(data.usePersistentCache){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			Use Negative Cache
			<i class="fa fa-question-circle south-east" title="Keeping negative DNS responses such as Server Failure or Non-existent Domain up to 15 minutes."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="useNegativeCache" <%if(data.useNegativeCache){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			Minimal Responses
			<i class="fa fa-question-circle south-east" title="Sending only Answer records in a DNS response and ignore other
				<br>sections for reducing DNS packet size and improving server performance."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="minimalResponses" <%if(data.minimalResponses){out.print("checked");}%>></td>
	</tr>
	
	<tr>
		<td>
			Minimum Cache TTL
			<i class="fa fa-question-circle south-east" title="Manipulating TTL value for a DNS response. Bigger minimum cache TTL
				<br>reduces the number of DNS queries from your clients."></i>
		</td>
		<td><input type="text" name="minCacheTtl" size="2" maxlength="4" value="<%= data.minCacheTtl%>"> seconds, 0 ~ 3600, 0 = Bypass</td>
	</tr>
	
	<tr>
		<td>Block Cache TTL</td>
		<td><input type="text" name="blockCacheTtl" size="2" maxlength="4" value="<%= data.blockCacheTtl%>"> seconds, 0 ~ 3600</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>

<%@include file="include/footer.jsp"%>
