<%@include file="include/zop,header.jsp"%>
<%!
//-----------------------------------------------
void update(OperatorDao dao){
	// Get old data.
	OperatorData data = dao.selectOne(getOpId());

	// Replace some values.
	data.email = paramString("email");
	data.alertPeriod = paramInt("alertPeriod");

	data.alertCategoryArr = paramArray("alertCategoryArr");

	// Alert events.
	data.recvAlertAdminBlock = paramBoolean("recvAlertAdminBlock");
	data.recvAlertCategoryBlock = paramBoolean("recvAlertCategoryBlock");
	data.recvAlertUnclassified = paramBoolean("recvAlertUnclassified");
	data.recvAlertBlockTime = paramBoolean("recvAlertBlockTime");
	data.recvAlertSystemBlock = paramBoolean("recvAlertSystemBlock");
	data.recvAlertOtherReasons = paramBoolean("recvAlertOtherReasons");

	// Param validation.
	if (data.alertPeriod > 0 && !isValidEmail(data.email)) {
		errList.add(translate("Invalid email."));
		return;
	}

	if(dao.update(data)){
		succList.add(translate("Update finished."));
	}
}

//-----------------------------------------------
void updatePw(OperatorDao dao){
	String newPw = paramString("newPw");
	String newPw2 = paramString("newPw2");
	String adminPw = paramString("adminPw");

	// Validate and update it.
	if(newPw.length() < 4 || !ParamTest.isValidPasswdLen(newPw)){
		errList.add(translate("Password length must be between 4 and 128."));
		return;
	}
	
	if(!ParamTest.isValidPasswdChar(newPw)){
		errList.add(translate("Only ascii character allowed in password."));
		return;
	}
	
	if(!newPw.equals(newPw2)){
		errList.add(translate("Passwords don't match."));
		return;
	}

	if(!dao.isOperatorPw(adminPw)){
		errList.add(translate("Wrong password."));
		return;
	}

	// Get old data.
	OperatorData data = dao.selectOne(getOpId());

	// Replace some values.
	data.passwd = newPw;

	if(dao.update(data)){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
OperatorDao dao = new OperatorDao(getOpId());

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("updatePw")){
	updatePw(dao);
}

// Global.
OperatorData data = dao.selectOne(getOpId());

// Active tab.
String tabActive0 = "";
String tabActive1 = "";
String tabActive2 = "";
String tabActive3 = "";

String showActive0 = "";
String showActive1 = "";
String showActive2 = "";
String showActive3 = "";

int tabIdx = paramInt("tabIdx");
if(tabIdx == 0){
	tabActive0 = " active";
	showActive0 = " show active";
}
else if(tabIdx == 1){
	tabActive1 = " active";
	showActive1 = " show active";
}
else if(tabIdx == 2){
	tabActive2 = " active";
	showActive2 = " show active";
}
else if(tabIdx == 3){
	tabActive3 = " active";
	showActive3 = " show active";
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("SYSTEM")%></li>
		<li class="breadcrumb-item text-info"><%= translate("SETUP")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Tab -->
	<div>
		<ul class="nav nav-tabs" style="margin-left:10px; margin-right:10px;">
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(0);">
				<a class="nav-link<%= tabActive0%>" data-toggle="tab" href="#tab0"><%= translate("ADMIN PASSWORD")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(1);">
				<a class="nav-link<%= tabActive1%>" data-toggle="tab" href="#tab1"><%= translate("ALERT EMAIL")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(2);">
				<a class="nav-link<%= tabActive2%>" data-toggle="tab" href="#tab2"><%= translate("ALERT EVENTS")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(3);">
				<a class="nav-link<%= tabActive3%>" data-toggle="tab" href="#tab3"><%= translate("ALERT CATEGORIES")%></a>
			</li>
		</ul>
	</div>
	<!-- Tab -->

	<!-- Form -->
	<form action="<%= getPageName()%>" method="post">
		<input type="hidden" name="actionFlag" value="update">
		<input type="hidden" id="tabIdx" name="tabIdx" value="<%= tabIdx%>">

		<!-- Tab content -->
		<div id="myTabContent" class="tab-content">

			<!-- Admin Password -->
			<div class="tab-pane <%= showActive0%>" id="tab0">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Current Password")%></label>
								<input type="password" class="form-control" id="adminPw" name="adminPw">
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("New Password")%></label>
								<input type="password" class="form-control" id="newPw" name="newPw">
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Confirm Password")%></label>
								<input type="password" class="form-control" id="newPw2" name="newPw2">
							</div>
							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary" onclick="javascript:this.form.actionFlag.value='updatePw';"><%= translate("SUBMIT")%></button>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Admin Password -->

			<!-- Alert Email -->
			<div class="tab-pane fade<%= showActive1%>" id="tab1">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Alert Email")%></label>
								<input type="text" class="form-control" id="email" name="email" value="<%= data.email%>">
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Alert Period")%>
									&nbsp;<i class="fa fa-question-circle south-east" title="<%= translate("Only for access violation emails.")%>"></i>
								</label>
								<select class="form-control" id="alertPeriod" name="alertPeriod">
<%
Map<Integer, String> periodMap = getAlertPeriodMap();
for(Map.Entry<Integer, String> entry : periodMap.entrySet()){
	Integer key = entry.getKey();
	String val = entry.getValue();

	if(key == data.alertPeriod){
		printf("<option value='%s' selected>%s</option>", key, translate(val));
	}
	else{
		printf("<option value='%s'>%s</option>", key, translate(val));
	}
}
%>
								</select>
							</div>
							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Alert Email -->

			<!-- Alert Events -->
			<div class="tab-pane fade<%= showActive2%>" id="tab2">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">

						<div class="form-group col-lg-8 text-secondary">
							<%= translate("You can receive notifications only for the events you are interested in.")%>
						</div>

						<fieldset>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="recvAlertAdminBlock"
										name="recvAlertAdminBlock" <%if(data.recvAlertAdminBlock){out.print("checked");}%>>
									<label class="custom-control-label" for="recvAlertAdminBlock"><%= translate("Receive alert emails for the block events by 'Admin Block'")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="recvAlertCategoryBlock"
										name="recvAlertCategoryBlock" <%if(data.recvAlertCategoryBlock){out.print("checked");}%>>
									<label class="custom-control-label" for="recvAlertCategoryBlock"><%= translate("Receive alert emails for the block events by 'Category'")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="recvAlertUnclassified"
										name="recvAlertUnclassified" <%if(data.recvAlertUnclassified){out.print("checked");}%>>
									<label class="custom-control-label" for="recvAlertUnclassified"><%= translate("Receive alert emails for the block events by 'Unclassified'")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="recvAlertBlockTime"
										name="recvAlertBlockTime" <%if(data.recvAlertBlockTime){out.print("checked");}%>>
									<label class="custom-control-label" for="recvAlertBlockTime"><%= translate("Receive alert emails for the block events by 'Block Time'")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="recvAlertSystemBlock"
										name="recvAlertSystemBlock" <%if(data.recvAlertSystemBlock){out.print("checked");}%>>
									<label class="custom-control-label" for="recvAlertSystemBlock"><%= translate("Receive alert emails for the block events by 'System Block'")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="recvAlertOtherReasons"
										name="recvAlertOtherReasons" <%if(data.recvAlertOtherReasons){out.print("checked");}%>>
									<label class="custom-control-label" for="recvAlertOtherReasons"><%= translate("Receive alert emails for the block events by other reasons")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Alert Events -->

			<!-- Alert Categories -->
			<div class="tab-pane fade<%= showActive3%>" id="tab3">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">

						<div class="form-group col-lg-8 text-secondary">
							<%= translate("This is only for when you block domains by categories in a policy.")%>
						</div>

						<fieldset>

<%
for(int i = 0; i < data.alertCategoryList.size();){

	out.println("<div class='form-group col-lg-8 row' style='padding-left: 30px'>");

	for(int k = 0; k < 4; k++){
		CategoryData cd = data.alertCategoryList.get(i);

		String chkLine = "";
		if(cd.checkFlag){
			chkLine = "checked";
		}
%>
								<div class="custom-control custom-checkbox col-lg-3">
									<input type="checkbox" class="custom-control-input" id="alertCategory-<%= i%>"
										name="alertCategoryArr" value="<%= cd.id%>" <%= chkLine%>>
									<label class="custom-control-label" for="alertCategory-<%= i%>"><%= cd.name%></label>
								</div>
<%
		if(++i >= data.alertCategoryList.size()){
			break;
		}
	}

	out.println("</div>");
}
%>

							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
								<button type="button" class="btn btn-info" onclick="javascript:checkboxToggleAll3('alertCategoryArr');"><%= translate("SELECT ALL")%></button>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Alert Categories -->

		</div>
		<!-- Tab content -->

	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<%@include file="include/zop,footer.jsp"%>

<script>
//-----------------------------------------------
// Restricts input for each element in the set of matched elements to the given inputFilter.
(function($) {
	$.fn.inputFilter = function(inputFilter){
		return this.on("input keydown keyup mousedown mouseup select contextmenu drop", function(){
			if (inputFilter(this.value)){
				this.oldValue = this.value;
				this.oldSelectionStart = this.selectionStart;
				this.oldSelectionEnd = this.selectionEnd;
			} else if (this.hasOwnProperty("oldValue")){
				this.value = this.oldValue;
				this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
			} else {
				this.value = "";
			}
		});
	};
}(jQuery));

// Install input filters.
$("#loginSessionTtl").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value);
});
$("#syslogPort").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value);
});
$("#routerPort").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value);
});
$("#logRetentionDays").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value) && parseInt(value) <= 400;
});
$("#autoBackupDays").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value) && parseInt(value) <= 30;
});
</script>
