<%@include file="include/zop,header.jsp"%>
<%!
//-----------------------------------------------
void update(OpBlockPageDao dao){
	BlockPageData data = new BlockPageData();

	// We use requestString here to preserve all the special characters.
	data.blockPage = requestString("blockPage");

	data.sanitize();
	if(data.blockPage.length() > BlockPageData.OP_MAX_PAGE_SIZE){
		errList.add(translate("Size too big."));
		return;
	}

	if(dao.update(data)){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
OpBlockPageDao dao = new OpBlockPageDao(getOpId());

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
BlockPageData data = dao.selectOne();
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("SYSTEM")%></li>
		<li class="breadcrumb-item text-info"><%= translate("BLOCK PAGE")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<div class="card bg-light m-2 expand-lg">
		<div class="card-body">
			<form action="<%= getPageName()%>" method="post">
				<input type="hidden" name="actionFlag" value="update">
				<fieldset>

					<div class="form-group col-lg-8 text-secondary">
						<%= translate("You can edit your block page here. When you don't have your own block page, the default block page will be served.", 1000)%>
					</div>

					<div class="form-group col-lg-8">
						<label class="col-form-label"><%= translate("Block Page")%></label>
						<textarea class="form-control" id="blockPage" name="blockPage" rows="8"><%= escapeHtml(data.blockPage)%></textarea>
					</div>

					<div class="form-group col-lg-8">
						<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
						<button type="button" class="btn btn-info" onclick="javascript:preview(this.form.blockPage.value);"><%= translate("VIEW BLOCK PAGE")%></button>
					</div>

				</fieldset>
			</form>
		</div>
	</div>

</div>
<!-- /Main content -->

<%@include file="include/zop,footer.jsp"%>

<script>
//-----------------------------------------------
function preview(text){
	var w = window.open("", "previewWindow", "width=1024,height=600");
	w.document.open();
	w.document.write(text);
	w.document.close();
}
</script>
