<%@include file="include/zop,header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object for chart.
H2ReportDao reportDao = new H2ReportDao(getAdminName());
ReportStatsData stats = reportDao.getStats();
ReportChartData domainTop = reportDao.getDomainTop(5);
ReportChartData categoryTop = reportDao.getCategoryTop(5);

// Create data access object for blocked list.
ZopRequestDao requestDao = new ZopRequestDao(getAdminName());
requestDao.page = 1;
requestDao.limit = 50;
requestDao.stime = strftimeAdd("yyyyMMddHHmm", 60 * 60 * -12);  // 12 hours ago.
requestDao.etime = strftime("yyyyMMddHHmm");
requestDao.blockFlag = true;

// Active tab.
String tabActive0 = "";
String tabActive1 = "";

String showActive0 = "";
String showActive1 = "";

int tabIdx = paramInt("tabIdx");
if(tabIdx == 0){
	tabActive0 = " active";
	showActive0 = " show active";
}
else if(tabIdx == 1){
	tabActive1 = " active";
	showActive1 = " show active";
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<style>
@media (max-width: 1000px) {
	.responsive-card {
		flex: 0 0 100% !important;
	}
}
</style>

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item text-info"><%= translate("DASHBOARD")%></li>
		<li class="breadcrumb-item"><%= reportDao.getStime()%> ~ <%= reportDao.getEtime()%></li>
		<li class="breadcrumb-item"><%= translate("DOMAIN")%> = <%= stats.domainCnt%></li>
		<li class="breadcrumb-item"><%= translate("USER")%> = <%= stats.userCnt%></li>
		<li class="breadcrumb-item"><%= translate("CLIENT IP")%> = <%= stats.cltIpCnt%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Tab -->
	<div>
		<ul class="nav nav-tabs" style="margin-left:10px; margin-right:10px;">
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(0);">
				<a class="nav-link<%= tabActive0%>" data-toggle="tab" href="#tab0"><%= translate("STATS FOR 2 HOURS")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(1);">
				<a class="nav-link<%= tabActive1%>" data-toggle="tab" href="#tab1"><%= translate("RECENT BLOCK")%></a>
			</li>
		</ul>
	</div>
	<!-- Tab -->

	<!-- Form -->
	<form action="<%= getPageName()%>" method="get">
		<input type="hidden" id="tabIdx" name="tabIdx" value="<%= tabIdx%>">

		<!-- Tab content -->
		<div id="myTabContent" class="tab-content">

			<!-- Stats for 2 hours -->
			<div class="tab-pane fade<%= showActive0%>" id="tab0">
				<div class="row m-2 expand-lg">
					<div style="display: flex; flex-wrap: wrap; gap: 20px; justify-content: space-between;">
						<div class="card responsive-card" style="flex: 0 0 48%; margin-top: 20px;">
							<div class="card-body">
								<canvas id="domain-top" style="width: 100%; height: 250px;"></canvas>
							</div>
						</div>
						<div class="card responsive-card" style="flex: 0 0 48%; margin-top: 20px;">
							<div class="card-body">
								<canvas id="domain-block" style="width: 100%; height: 250px;"></canvas>
							</div>
						</div>
						<div class="card responsive-card" style="flex: 0 0 48%; margin-top: 20px;">
							<div class="card-body">
								<canvas id="category-top" style="width: 100%; height: 250px;"></canvas>
							</div>
						</div>
						<div class="card responsive-card" style="flex: 0 0 48%; margin-top: 20px;">
							<div class="card-body">
								<canvas id="category-block" style="width: 100%; height: 250px;"></canvas>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- /Stats for 2 hours -->

			<!-- Recent block -->
			<div class="tab-pane fade<%= showActive1%>" id="tab1">
				<div id="listDiv" class="container-fluid" style="display: none;">
					<table id="list" class="cell-border hover" style="width:100%">
						<thead>
							<tr>
								<th><%= translate("Time")%></th>
								<th><%= translate("Count")%></th>
								<th><%= translate("Type")%></th>
								<th><%= translate("Domain")%></th>
								<th><%= translate("User")%></th>
								<th><%= translate("Client IP")%></th>
								<th><%= translate("Operator")%></th>
								<th><%= translate("Policy")%></th>
								<th><%= translate("Category")%></th>
							</tr>
						</thead>
						<tbody>
<%
List<RequestData> dataList = requestDao.selectList();

for(int i = 0; i < dataList.size(); i++){
	RequestData data = dataList.get(i);

	String categoryLine = data.category;
	if(categoryLine.length() > 30){
		categoryLine = safeSubstring(data.category, 30) + "..";
	}

	if(data.getBlockYn().equals("Y") && data.getReason().contains("category")){
		//categoryLine = "<span class='logging-category'>" + categoryLine + "</span>";
	}
%>
							<tr>
								<td><%= data.getCtime()%></td>
								<td><%= data.cnt%></td>
								<td><%= data.getTypeCode()%></td>
								<td><%= data.domain%><span class="logging-reason"><%= data.getReason()%></span></td>
								<td><%= data.user%></td>
								<td><%= data.cltIp%></td>
								<td><%= data.operator%></td>
								<td><%= data.policy%></td>
								<td title="<%= data.category%>"><%= categoryLine%></td>
							</tr>
<%}%>
						</tbody>
					</table>
				</div>
			</div>
			<!-- /Recent block -->

		</div>
		<!-- Tab content -->

	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<%@include file="include/zop,footer.jsp"%>

<script>
$(document).ready(function(){
	$("#list").DataTable({
		"pageLength": 25,
		"bLengthChange" : false,
		"initComplete": function(settings, json){
			$("#listDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
// Domain top.
<%
StringBuilder labelLine = new StringBuilder();
StringBuilder dataLine = new StringBuilder();
List<String[]> arrList = domainTop.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	if(i > 0){
		labelLine.append(", ");
		dataLine.append(", ");
	}
	labelLine.append("'" + arr[0] + "'");
	dataLine.append(arr[1]);
}
%>
new Chart(document.getElementById("domain-top"), {
	type: "doughnut",
	data: {
		labels: [<%= labelLine.toString()%>],
		datasets: [{
			backgroundColor: ["#3e95cd", "#8e5ea2","#3cba9f","#e8c3b9","#c45850"],
			data: [<%= dataLine.toString()%>]
		}]
	},
	options: {
		maintainAspectRatio: false,
		title: {
			display: true,
			text: '<%= translate("Top 5 domains by request")%>'
		}
	}
});

//-----------------------------------------------
// Domain block.
<%
labelLine = new StringBuilder();
dataLine = new StringBuilder();
arrList = domainTop.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	if(i > 0){
		labelLine.append(", ");
		dataLine.append(", ");
	}
	labelLine.append("'" + arr[0] + "'");
	dataLine.append(arr[1]);
}
%>
new Chart(document.getElementById("domain-block"), {
	type: "pie",
	data: {
		labels: [<%= labelLine.toString()%>],
		datasets: [{
			backgroundColor: ["#3e95cd", "#8e5ea2","#3cba9f","#e8c3b9","#c45850"],
			data: [<%= dataLine.toString()%>]
		}]
	},
	options: {
		maintainAspectRatio: false,
		title: {
			display: true,
			text: '<%= translate("Top 5 domains by block")%>'
		}
	}
});

//-----------------------------------------------
// Category top.
<%
labelLine = new StringBuilder();
dataLine = new StringBuilder();
arrList = categoryTop.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	if(i > 0){
		labelLine.append(", ");
		dataLine.append(", ");
	}
	labelLine.append("'" + arr[0] + "'");
	dataLine.append(arr[1]);
}
%>
new Chart(document.getElementById("category-top"), {
	type: "pie",
	data: {
		labels: [<%= labelLine.toString()%>],
		datasets: [{
			backgroundColor: ["#3e95cd", "#8e5ea2","#3cba9f","#e8c3b9","#c45850"],
			data: [<%= dataLine.toString()%>]
		}]
	},
	options: {
		maintainAspectRatio: false,
		title: {
			display: true,
			text: '<%= translate("Top 5 categories by request")%>'
		}
	}
});

//-----------------------------------------------
// Category block.
<%
labelLine = new StringBuilder();
dataLine = new StringBuilder();
arrList = categoryTop.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	if(i > 0){
		labelLine.append(", ");
		dataLine.append(", ");
	}
	labelLine.append("'" + arr[0] + "'");
	dataLine.append(arr[1]);
}
%>
new Chart(document.getElementById("category-block"), {
	type: "doughnut",
	data: {
		labels: [<%= labelLine.toString()%>],
		datasets: [{
			backgroundColor: ["#3e95cd", "#8e5ea2","#3cba9f","#e8c3b9","#c45850"],
			data: [<%= dataLine.toString()%>]
		}]
	},
	options: {
		maintainAspectRatio: false,
		title: {
			display: true,
			text: '<%= translate("Top 5 categories by block")%>'
		}
	}
});
</script>
