<%@include file="include/zop,header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addOperator();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
CategorySystemDao dao = new CategorySystemDao();
CategoryCustomDao dao2 = new CategoryCustomDao();
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("CATEGORY")%></li>
		<li class="breadcrumb-item text-info"><%= translate("SYSTEM")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Form -->
<div class="container-fluid">
	<div class="card bg-light m-2 expand-lg">
		<div class="card-body">
			<%= translate("System categories for domain classification.")%>
		</div>
	</div>
</div>
<!-- /Form -->

<!-- List -->
<div id="listDiv" class="container-fluid" style="display: none;">
	<div class="m-2 expand-lg">
		<table id="list" class="cell-border hover" style="width:100%">
			<thead>
				<tr>
					<th><%= translate("Name")%></th>
					<th><%= translate("Description")%></th>
				</tr>
			</thead>
			<tbody>
<%
List<CategoryData> dataList = dao.selectList();

// Add custom categories.
dataList.addAll(dao2.selectList());

for(int i = 0; i < dataList.size(); i++){
	CategoryData data = dataList.get(i);

	String name = data.name;
	int domainCnt = data.getDomainCount();
	if(domainCnt > 0){
		name = name + " - " + domainCnt;
	}
%>
				<tr>
					<td><%= name%></td>
					<td><%= data.description%></td>
				</tr>
<%}%>
			</tbody>
		</table>
	</div>
</div>
<!-- /List -->

<%@include file="include/zop,footer.jsp"%>

<script>
//-----------------------------------------------
$(document).ready(function(){
	$("#list").DataTable({
		"bFilter" : false,
		"paging" : false,
		"ordering" : false,
		"info" : true,
		"autoWidth" : false,
		"columnDefs": [{
			"targets": 0,
			"width": "200"
		}],
		"initComplete": function(settings, json){
			$("#loadingDiv").hide();
			$("#listDiv").show();
		},
		language : langMulti,
	});
});
</script>
