<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
boolean checkParam(AlertData data){
	if (isNotEmpty(data.adminEmail) && !isValidEmail(data.adminEmail)) {
		errList.add(translate("Invalid email address."));
		return false;
	}

	return true;
}

//-----------------------------------------------
boolean update(AlertDao dao){
	AlertData oldData = dao.selectOne();
	AlertData data = new AlertData();

	data.adminEmail = paramString("adminEmail");
	data.adminCc = paramString("adminCc");
	data.smtpHost = paramString("smtpHost");
	data.smtpPort = paramInt("smtpPort");
	data.smtpEncType = paramInt("smtpEncType");
	data.smtpUser = paramString("smtpUser");
	data.smtpPasswd = paramString("smtpPasswd");

	// Validate and update it.
	if(checkParam(data) && dao.update(data)){
		succList.add(translate("Update finished."));
		return true;
	}

	return false;
}

//-----------------------------------------------
void test(AlertDao dao){
	if(!update(dao)){
		return;
	}

	try{
		dao.test();
		succList.add(translate("Test email has been sent."));
	}
	catch(Exception e){
		errList.add(e.toString());
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
AlertDao dao = new AlertDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("test")){
	test(dao);
}

// Global.
AlertData data = dao.selectOne();
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("SYSTEM")%></li>
		<li class="breadcrumb-item text-info"><%= translate("ALERT")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Form -->
	<form action="<%= getPageName()%>" method="post">
		<input type="hidden" name="actionFlag" value="update">
		<div class="card bg-light m-2 expand-lg">
			<div class="card-body">
				<fieldset>
					<div class="form-group col-lg-8 text-secondary">
						<%= translate("NxCloud sends you emails regarding license and system related events.", 1000)%>
					</div>
					<div class="form-group col-lg-8">
						<label class="col-form-label"><%= translate("Admin Email")%></label>
						<input type="text" class="form-control" id="adminEmail" name="adminEmail" value="<%= data.adminEmail%>">
					</div>
					<div class="form-group col-lg-8">
						<label class="col-form-label">
							<%= translate("CC Recipients")%>
						</label>
						<input type="text" class="form-control" id="adminCc" name="adminCc" value="<%= data.adminCc%>">
					</div>
					<div class="form-group col-lg-8">
						<label class="col-form-label"><%= translate("SMTP Host")%></label>
						<input type="text" class="form-control" id="smtpHost" name="smtpHost" value="<%= data.smtpHost%>">
					</div>
					<div class="form-group col-lg-8">
						<label class="col-form-label"><%= translate("SMTP Port")%></label>
						<input type="text" class="form-control" id="smtpPort" name="smtpPort" value="<%= data.smtpPort%>">
					</div>
					<div class="form-group col-lg-8">
						<label class="col-form-label">SSL/TLS</label>
						<select class="form-control" id="smtpEncType" name="smtpEncType">
							<option value="0" <%if(data.smtpEncType == 0){out.print("selected");}%>><%= translate("None")%></option>
							<option value="1" <%if(data.smtpEncType == 1){out.print("selected");}%>>SSL</option>
							<option value="2" <%if(data.smtpEncType == 2){out.print("selected");}%>>STARTTLS</option>
						</select>
					</div>
					<div class="form-group col-lg-8">
						<label class="col-form-label"><%= translate("SMTP User")%></label>
						<input type="text" class="form-control" id="smtpUser"
							name="smtpUser" value="<%= data.smtpUser%>">
					</div>
					<div class="form-group col-lg-8">
						<label class="col-form-label"><%= translate("SMTP Password")%></label>
						<input type="password" class="form-control" id="smtpPasswd"
							name="smtpPasswd" value="<%= data.smtpPasswd%>">
					</div>
					<div class="form-group col-lg-8">
						<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
						<button type="button" class="btn btn-info" onclick="javascript:actionTest(this.form);"><%= translate("TEST")%></button>
					</div>
				</fieldset>
			</div>
		</div>
	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<%@include file="include/footer.jsp"%>

<script>
// Restricts input for each element in the set of matched elements to the given inputFilter.
(function($) {
	$.fn.inputFilter = function(inputFilter){
		return this.on("input keydown keyup mousedown mouseup select contextmenu drop", function(){
			if (inputFilter(this.value)){
				this.oldValue = this.value;
				this.oldSelectionStart = this.selectionStart;
				this.oldSelectionEnd = this.selectionEnd;
			} else if (this.hasOwnProperty("oldValue")){
				this.value = this.oldValue;
				this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
			} else {
				this.value = "";
			}
		});
	};
}(jQuery));

// Install input filters.
$("#smtpPort").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value);
});

if($("#smtpPort").val() == "" || $("#smtpPort").val() == 0){
	$("#smtpPort").val(25);
}

//-----------------------------------------------
function actionTest(form){
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "test";
	form.submit();
}
</script>
