<%@include file="include/xop,header.jsp"%>
<%!
//-----------------------------------------------
void insert(SignupRequestDao dao){
	SignupRequestData data = new SignupRequestData();

	data.username = paramString("username");
	data.passwd = paramString("passwd");
	data.email = paramString("email");

	String confirmPasswd = paramString("confirmPasswd");
 
	// Param validation.
	if(isEmpty(data.username)){
		errList.add(translate("Username missing."));
		return;
	}
	
	// Username.
	if(data.username.length() < 4 || data.username.length() > 20){
		errList.add(translate("Username length must be between 4 and 20."));
		return;
	}
	
	if(!ParamTest.isValidUsernameChar(data.username)){
		errList.add(translate("Only alphabet, number, [.@-_] allowed in username."));
		return;
	}

	if (ParamTest.isDupSignupUsername(data.username)) {
		errList.add(translate("Username already exists."));
		return;
	}

	// Password.
	if(isEmpty(data.passwd)){
		errList.add(translate("Password missing."));
		return;
	}

	if(isEmpty(confirmPasswd) || !data.passwd.equals(confirmPasswd)){
		errList.add(translate("Passwords don't match."));
		return;
	}

	if(data.passwd.length() < 4 || !ParamTest.isValidPasswdLen(data.passwd)){
		errList.add(translate("Password length must be between 4 and 128."));
		return;
	}
	
	if(!ParamTest.isValidPasswdChar(data.passwd)){
		errList.add(translate("Only ASCII character allowed in password."));
		return;
	}

	// Email.
	if(isEmpty(data.email) || data.email.length() > 100 || !data.email.contains("@")){
		errList.add(translate("Invalid email address."));
		return;
	}
	
	// Validate and update it.
	if(dao.insert(data)){
		succList.add(translate("Your signup request has been submitted."));
	}
}
%>
<%
//-----------------------------------------------
// Create data access object.
SignupRequestDao dao = new SignupRequestDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("signup")){
	insert(dao);
}

// Global.
String gUsername = paramString("username");
String gEmail = paramString("email");
%>
<!-- Action info -->
<%@include file="include/xb-notify.jsp"%>
<!-- /Action info -->

<!-- Modal HTML -->
<div id="login-form" class="d-flex justify-content-center" data-backdrop="false" style="margin-top: 150px;">
	<div class="modal-dialog modal-login">
		<div class="modal-content">

			<div class="modal-body">
				<form method="post" action="<%= getPageName()%>">
					<input type="hidden" name="actionFlag" value="signup">
					<div class="form-group">
						<i class="fa fa-user"></i>
						<input type="text" name="username" class="form-control" placeholder="<%= translate("Username")%>" value="<%= gUsername%>" required="required">
					</div>
					<div class="form-group">
						<i class="fa fa-lock"></i>
						<input type="password" name="passwd" class="form-control" placeholder="<%= translate("Password")%>" required="required"
							onkeypress="javascript:if(event.keyCode == 13){this.form.submit(); return;}">
					</div>
					<div class="form-group">
						<i class="fa fa-lock"></i>
						<input type="password" name="confirmPasswd" class="form-control" placeholder="<%= translate("Confirm Password")%>" required="required"
							onkeypress="javascript:if(event.keyCode == 13){this.form.submit(); return;}">
					</div>
					<div class="form-group">
						<i class="fa fa-envelope"></i>
						<input type="text" name="email" class="form-control" placeholder="<%= translate("Email")%>" value="<%= gEmail%>" required="required">
					</div>
					<div class="form-group" style="margin-bottom: -5px;">
						<input type="submit" class="btn btn-primary btn-block btn-lg" style="font-size: 1.3rem; font-weight: bold;" value="<%= translate("SIGNUP")%>">
					</div>
				</form>			
			</div>

			<div style="margin-top: -10; text-align: center; color: #A6A6A6; padding: 2px;">
				<%= translate("Already have an account?")%>&nbsp;<a href="admin.jsp"><%= translate("Login here")%></a>
			</div>

		</div>
	</div>
</div>

<%@include file="include/xop,footer.jsp"%>

<script>
$(document).ready(function(){
	$("#login-form").modal("show");
});
</script>