<%@include file="include/xop,header.jsp"%>
<%!
//-----------------------------------------------
void resetPw(OperatorDao dao){
	String username = paramString("username");
	String email = paramString("email");

	OperatorData data = dao.selectOneByName(username);
	if(data == null){
		errList.add(translate("No such user found."));
		return;
	}

	if(isEmpty(data.email) || !data.email.equals(email)){
		errList.add(translate("Invalid email address."));
		return;
	}

	// New password.
	String newPw = dao.makeRandomPasswd();
	data.passwd = newPw;

	if(!dao.update(data)){
		errList.add(translate("Username missing."));
		return;
	}

	// Reset password.
	String subj = translate("Your password has been reset.");
	String message = translateF("Your new password : %s", newPw);
	if(AlertDao.sendPasswordResetEmail(subj, message, data.email)){
		succList.add(translate("New password has been sent."));
	}
	else{
		errList.add(translate("Couldn't send an email."));
	}
}
%>
<%
//-----------------------------------------------
// Create data access object.
OperatorDao dao = new OperatorDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("resetPw")){
	resetPw(dao);
}

// Global.
String gUsername = paramString("username");
String gEmail = paramString("email");
%>
<!-- Action info -->
<%@include file="include/xb-notify.jsp"%>
<!-- /Action info -->

<!-- Modal HTML -->
<div id="login-form" class="d-flex justify-content-center" data-backdrop="false" style="margin-top: 150px;">
	<div class="modal-dialog modal-login">
		<div class="modal-content">

			<div class="modal-body">
				<form method="post" action="<%= getPageName()%>">
					<input type="hidden" name="actionFlag" value="resetPw">
					<div class="form-group">
						<i class="fa fa-user"></i>
						<input type="text" name="username" class="form-control" placeholder="<%= translate("Username")%>" value="<%= gUsername%>" required="required">
					</div>
					<div class="form-group">
						<i class="fa fa-envelope"></i>
						<input type="text" name="email" class="form-control" placeholder="<%= translate("Email")%>" value="<%= gEmail%>" required="required">
					</div>
					<div class="form-group" style="margin-bottom: -5px;">
						<input type="submit" class="btn btn-primary btn-block btn-lg" style="font-size: 1.3rem; font-weight: bold;" value="<%= translate("RESET PASSWORD")%>">
					</div>
				</form>			
			</div>

			<div style="margin-top: -10; text-align: center; color: #A6A6A6; padding: 2px;">
				<%= translate("Found your password?")%>&nbsp;<a href="admin.jsp"><%= translate("Login here")%></a>
			</div>

		</div>
	</div>
</div>

<%@include file="include/xop,footer.jsp"%>

<script>
$(document).ready(function(){
	$("#login-form").modal("show");
});
</script>