<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Global.
ConfigDao cfgDao = new ConfigDao();
String gUptime = cfgDao.getUptimeInfo();
String gStartTime = cfgDao.getStartTime();
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("REPORT")%></li>
		<li class="breadcrumb-item text-info"><%= translate("USAGE")%></li>
		<li class="breadcrumb-item">Up <%= gUptime%>&nbsp;<span class="text-info">(<%= translate("Since")%> <%= gStartTime%>)</span></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- List -->
<div id="listDiv" class="container-fluid" style="display: none;">
	<div class="m-2 expand-lg">
		<table id="list" class="cell-border hover" style="width:100%">
			<thead>
				<tr>
					<th></th>
					<th><%= translate("Time")%></th>
					<th><%= translate("Request (total / unique)")%></th>
					<th><%= translate("Block (total / unique)")%></th>
					<th><%= translate("Domain")%></th>
					<th><%= translate("Operator")%></th>
					<th><%= translate("User")%></th>
					<th><%= translate("Client IP")%></th>
				</tr>
			</thead>
			<tbody>
<%
for(int i = 0; i < 30; i++){
	String stime = strftimeAdd("yyyyMMdd", (86400 * i * -1) - 1);

	D1ReportDao dao = new D1ReportDao(stime);
	ReportStatsData stats = dao.getStats();
%>
				<tr>
					<td><%= dao.stime%></td>
					<td><%= dao.getStime()%></td>
					<td><%= stats.reqSum%> / <%= stats.reqCnt%></td>
					<td><%= stats.blockSum%> / <%= stats.blockCnt%></td>
					<td><%= stats.domainCnt%></td>
					<td><%= stats.opCnt%></td>
					<td><%= stats.userCnt%></td>
					<td><%= stats.cltIpCnt%></td>
				</tr>
<%}%>
			</tbody>
		</table>
	</div>
</div>
<!-- /List -->

<%@include file="include/footer.jsp"%>

<script>
$(document).ready(function(){
	$("#list").DataTable({
		"paging" : false,
		"bLengthChange" : true,
		"ordering" : false,
		"info" : true,
		"aaSorting": [[0, "desc"]],
		"columnDefs": [{
			"targets": 0,
			"visible": false,
			"searchable": false,
		}],
		"initComplete": function(settings, json){
			$("#listDiv").show();
		},
		language : langMulti,
	});
});
</script>
