<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}


// Create data access object.
OperatorStatsDao dao = new OperatorStatsDao();
dao.limit = 1000;
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("REPORT")%></li>
		<li class="breadcrumb-item text-info"><%= translate("OPERATOR STATS")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- List -->
<div id="listDiv" class="container-fluid" style="display: none;">
	<div class="m-2 expand-lg">
		<table id="list" class="cell-border hover" style="width:100%">
			<thead>
				<tr>
					<th></th>
					<th><%= translate("Time")%></th>
					<th><%= translate("Operator")%></th>
					<th><%= translate("Request (total / unique)")%></th>
					<th><%= translate("Block (total / unique)")%></th>
					<th><%= translate("Domain")%></th>
					<th><%= translate("User")%></th>
					<th><%= translate("Client IP")%></th>
					<th><%= translate("Local IP")%></th>
					<th><%= translate("Signal")%></th>
				</tr>
			</thead>
			<tbody>
<%
List<OperatorStatsData> dataList = dao.selectList();
for(int i = 0; i < dataList.size(); i++){
	OperatorStatsData data = dataList.get(i);
%>
				<tr>
					<td><%= data.ctime%></td>
					<td><%= data.getCtime()%></td>
					<td><%= data.operator%></td>
					<td><%= data.requestSum%> / <%= data.requestCnt%></td>
					<td><%= data.blockSum%> / <%= data.blockCnt%></td>
					<td><%= data.domainCnt%></td>
					<td><%= data.userCnt%></td>
					<td><%= data.cltIpCnt%></td>
					<td><%= data.localIpCnt%></td>
					<td><%= data.signalCnt%></td>
				</tr>
<%}%>
			</tbody>
		</table>
	</div>
</div>
<!-- /List -->

<%@include file="include/footer.jsp"%>

<script>
$(document).ready(function(){
	$("#list").DataTable({
		"pageLength": 25,
		"lengthMenu": [[25, 50, 100], [25, 50, 100]],
		"bLengthChange" : true,
		"info" : true,
		"aaSorting": [[0, "desc"]],
		"columnDefs": [{
			"targets": 0,
			"visible": false,
			"searchable": false,
		}],
		"initComplete": function(settings, json){
			$("#loadingDiv").hide();
			$("#listDiv").show();
		},
		language : langMulti,
	});
});
</script>
