<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
UserDao dao = new UserDao(paramInt("opId"));
UserTestDao utDao = new UserTestDao();

// Global.
UserData data = dao.selectOne(paramInt("id"));
UserTestData utData = utDao.test(data.name);
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item clickable-li" onclick="window.location.href='operator,operator.jsp';"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item"><%= translate("EDIT")%></li>
		<li class="breadcrumb-item"><%= translate("USER")%></li>
		<li class="breadcrumb-item text-info"><%= translate("VIEW")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<div class="card bg-light m-2 expand-lg">
		<div class="card-body">
			<form action="<%= getPageName()%>" method="post">
				<input type="hidden" name="actionFlag" value="update">

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("Name")%>
					</label>
					<input type="text" class="form-control" value="<%= data.name%>" disabled>
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("Description")%>
					</label>
					<input type="text" class="form-control" value="<%= data.description%>">
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("Work-time Policy")%>
					</label>
					<input type="text" class="form-control" value="<%= data.policyName%>">
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("Free-time Policy")%>
					</label>
					<input type="text" class="form-control" value="<%= data.ftPolicyName%>">
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("Applied Policy")%>
					</label>
					<input type="text" class="form-control" value="<%= utData.appliedPolicyName%>">
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("Free-time")%>
					</label>
					<input type="text" class="form-control" value="<%= utData.isFreeTime ? "Yes" : "No"%>">
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("Login Token")%>
					</label>
					<input type="text" class="form-control" value="<%= data.token%>">
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("Associated IP")%>
					</label>
					<input type="text" class="form-control" value="<%= data.getIpLine()%>">
				</div>

			</form>
		</div>
	</div>

</div>
<!-- /Main content -->

<%@include file="include/footer.jsp"%>
