<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void approve(SignupRequestDao dao){
	if(dao.approve(paramInt("id"))){
		succList.add(translate("Update finished."));
	}
}

//-----------------------------------------------
void delete(SignupRequestDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	if(dao.delete(paramInt("id"))){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
SignupRequestDao dao = new SignupRequestDao();
dao.limit = 1000;

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("approve")){
	approve(dao);
}
if(actionFlag.equals("delete")){
	delete(dao);
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item text-info"><%= translate("SIGNUP REQUEST")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- List -->
<div id="listDiv" class="container-fluid" style="display: none;">
	<div class="m-2 expand-lg">
		<table id="list" class="cell-border hover" style="width:100%">
			<thead>
				<tr>
					<th></th>
					<th><%= translate("Time")%></th>
					<th><%= translate("Username")%></th>
					<th><%= translate("Email")%></th>
					<th></th>
				</tr>
			</thead>
			<tbody>
<%
List<SignupRequestData> dataList = dao.selectList();
for(int i = 0; i < dataList.size(); i++){
	SignupRequestData data = dataList.get(i);
%>
				<tr>
					<td><%= data.id%></td>
					<td><%= data.getCtime()%></td>
					<td><%= data.username%></td>
					<td><%= data.email%></td>
					<td>
						<i class="fa fa-trash pointer-cursor" title="<%= translate("Delete")%>"
							onclick="javascript:actionDelete(<%= data.id%>, '<%= data.username%>')"></i>
		<%if(!data.approvedFlag){%>
						<i class="fa fa-user-plus pointer-cursor" title="<%= translate("Approve")%>"
							onclick="javascript:actionApprove(<%= data.id%>, '<%= data.username%>')"></i>&nbsp;
		<%}%>
					</td>
				</tr>
<%}%>
			</tbody>
		</table>
	</div>
</div>
<!-- /List -->

<!-- goForm -->
<form action="<%= getPageName()%>" name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="">
</form>
<!-- /goForm -->
<%@include file="include/footer.jsp"%>

<script>
//-----------------------------------------------
$(document).ready(function(){
	$("#list").DataTable({
		"pageLength": 25,
		"lengthMenu": [[25, 50, 100], [25, 50, 100]],
		"bLengthChange" : true,
		"aaSorting": [[0, "desc"]],
		"columnDefs": [{
			"targets": 0,
			"visible": false,
			"searchable": false,
		}],
		"initComplete": function(settings, json){
			$("#listDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
function actionApprove(id, uname){
	if(!confirm('<%= translate("Approve the signup request")%> : ' + uname)){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "approve";
	form.id.value = id;

	form.submit();
}

//-----------------------------------------------
function actionDelete(id, name){
	if(!confirm('<%= translate("Deleting signup request")%> : ' + name)){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "delete";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
// Prevent submit again.
if(window.history.replaceState){
	window.history.replaceState(null, null, window.location.href);
}
</script>
