<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
PolicyDao dao = new PolicyDao();

// Global.
PolicyData data = dao.selectOne(paramInt("id"));

// Active tab.
String tabActive0 = "";
String tabActive1 = "";

String showActive0 = "";
String showActive1 = "";

int tabIdx = paramInt("tabIdx");
if(tabIdx == 0){
	tabActive0 = " active";
	showActive0 = " show active";
}
else if(tabIdx == 1){
	tabActive1 = " active";
	showActive1 = " show active";
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item clickable-li" onclick="window.location.href='operator,operator.jsp';"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item"><%= translate("EDIT")%></li>
		<li class="breadcrumb-item"><%= translate("POLICY")%></li>
		<li class="breadcrumb-item text-info"><%= translate("VIEW")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Tab -->
	<div>
		<ul class="nav nav-tabs" style="margin-left:10px; margin-right:10px;">
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(0);">
				<a class="nav-link<%= tabActive0%>" data-toggle="tab" href="#tab0"><%= translate("EDIT")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(1);">
				<a class="nav-link<%= tabActive1%>" data-toggle="tab" href="#tab1"><%= translate("BLOCKED CATEGORIES")%></a>
			</li>
		</ul>
	</div>
	<!-- Tab -->

	<!-- Form -->
	<form action="<%= getPageName()%>" method="post">
		<input type="hidden" name="actionFlag" value="update">
		<input type="hidden" id="tabIdx" name="tabIdx" value="<%= tabIdx%>">
		<input type="hidden" name="id" value="<%= data.id%>">
 
		<!-- Tab content -->
		<div id="myTabContent" class="tab-content">

			<!-- Edit -->
			<div class="tab-pane <%= showActive0%>" id="tab0">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Name")%></label>
								<input type="text" class="form-control" id="host" name="host" value="<%= data.name%>" disabled>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Description")%></label>
								<input type="text" class="form-control" id="description" name="description" value="<%= data.description%>">
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="enableFilter"
										name="enableFilter" <%if(data.enableFilter){out.print("checked");}%>>
									<label for="enableFilter" class="custom-control-label"><%= translate("Enable Filter")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="blockAll"
										name="blockAll" <%if(data.blockAll){out.print("checked");}%>>
									<label for="blockAll" class="custom-control-label"><%= translate("Block All")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="blockUnclass"
										name="blockUnclass" <%if(data.blockUnclass){out.print("checked");}%>>
									<label for="blockUnclass" class="custom-control-label"><%= translate("Block Unclassified")%></label>
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Safe Search Enforcing")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("Enforcing Safe Search against Google, Bing, Youtube.")%>"></i>
								</label>
								<select class="form-control" id="safeMode" name="safeMode">
									<option value="0" <%if(data.safeMode == 0){out.print("selected");}%>><%= translate("Off")%></option>
									<option value="1" <%if(data.safeMode == 1){out.print("selected");}%>><%= translate("Moderate")%></option>
									<option value="2" <%if(data.safeMode == 2){out.print("selected");}%>><%= translate("Strict")%></option>
								</select>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="safeModeWithoutYoutube"
										name="safeModeWithoutYoutube" <%if(data.safeModeWithoutYoutube){out.print("checked");}%>>
									<label for="safeModeWithoutYoutube" class="custom-control-label"><%= translate("Exclude Youtube from Safe Search Enforcing")%></label>
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Block Time")%></label>
								<div class="form-row" style="margin-left: 2px;">
<%
List<String> hhList = getHhList();
List<String> mmList = getMmList();
%>
									<select class="form-control col-lg-1 col-md-1" id="stimeHh" name="stimeHh">
<%
for(String hh : hhList){
	if(data.btStime.startsWith(hh)){
		printf("<option value='%s' selected>%s</option>", hh, hh);
	}
	else{
		printf("<option value='%s'>%s</option>", hh, hh);
	}
}
%>
									</select>&nbsp;

									<select class="form-control col-lg-1 col-md-1" id="stimeMm" name="stimeMm">
<%
for(String mm : mmList){
	if(data.btStime.endsWith(mm)){
		printf("<option value='%s' selected>%s</option>", mm, mm);
	}
	else{
		printf("<option value='%s'>%s</option>", mm, mm);
	}
}
%>
									</select>&nbsp;~&nbsp;

									<select class="form-control col-lg-1 col-md-1" id="etimeHh" name="etimeHh">
<%
for(String hh : hhList){
	if(data.btEtime.startsWith(hh)){
		printf("<option value='%s' selected>%s</option>", hh, hh);
	}
	else{
		printf("<option value='%s'>%s</option>", hh, hh);
	}
}
%>
									</select>&nbsp;

									<select class="form-control col-lg-1 col-md-1" id="etimeMm" name="etimeMm">
<%
for(String mm : mmList){
	if(data.btEtime.endsWith(mm)){
		printf("<option value='%s' selected>%s</option>", mm, mm);
	}
	else{
		printf("<option value='%s'>%s</option>", mm, mm);
	}
}
%>
									</select>
								</div>
							</div>

							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="logOnly"
										name="logOnly" <%if(data.logOnly){out.print("checked");}%>>
									<label for="logOnly" class="custom-control-label"><%= translate("Logging without Block")%>
									</label>
								</div>
							</div>

						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Edit -->

			<!-- Blocked Categories -->
			<div class="tab-pane fade<%= showActive1%>" id="tab1">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>

<%
List<CategoryData> blockCategoryList = data.blockCategoryList;
for(int i = 0; i < blockCategoryList.size();){

	out.println("<div class='form-group col-lg-8 row' style='padding-left: 30px'>");

	for(int k = 0; k < 4; k++){
		CategoryData cd = blockCategoryList.get(i);

		String chkLine = "";
		if(cd.checkFlag){
			chkLine = "checked";
		}
%>
							<div class="custom-control custom-checkbox col-lg-3">
								<input type="checkbox" class="custom-control-input" id="blockedCategory-<%= i%>"
									name="blockCategoryArr" value="<%= cd.id%>" <%= chkLine%>>
								<label class="custom-control-label" for="blockedCategory-<%= i%>"><%= cd.name%></label>
							</div>
<%
		if(++i >= blockCategoryList.size()){
			break;
		}
	}

	out.println("</div>");
}
%>


						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Blocked Categories -->

		</div>
		<!-- Tab content -->

	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<%@include file="include/footer.jsp"%>
