<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
UserDao dao = new UserDao();
dao.limit = 100000;

// Active tab.
String tabActive0 = "";
String tabActive1 = "";

String showActive0 = "";
String showActive1 = "";

int tabIdx = paramInt("tabIdx");
if(tabIdx == 0){
	tabActive0 = " active";
	showActive0 = " show active";
}
else if(tabIdx == 1){
	tabActive0 = " active";
	showActive0 = " show active";
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item text-info"><%= translate("USER")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Form -->
	<form action="<%= getPageName()%>" method="post">
		<input type="hidden" name="actionFlag" value="insert">
		<input type="hidden" id="tabIdx" name="tabIdx" value="<%= tabIdx%>">

		<!-- List -->
		<div id="loadingDiv" class="container-fluid" style="display: block;">
			<table class="cell-border hover" style="width: 100%">
				<tr height="500">
					<td width="100%" align="center" valign="center">
						<img src="img/loading.gif?<%= new Random().nextInt(10000)%>">
					</td>
				<tr>
			</table>
		</div>
		<div id="listDiv" class="container-fluid" style="display: none;">
			<table id="list" class="cell-border hover" style="width:100%">
				<thead>
					<tr>
						<th><%= translate("Operator")%></th>
						<th><%= translate("User")%></th>
						<th><%= translate("Login Token")%></th>
						<th><%= translate("IP")%></th>
						<th><%= translate("Policy")%></th>
						<th><%= translate("Description")%></th>
						<th></th>
					</tr>
				</thead>
				<tbody>
<%
List<UserData> dataList = dao.selectListAll();
for(int i = 0; i < dataList.size(); i++){
	UserData data = dataList.get(i);

	String ipLine = data.getIpLine();
	if(ipLine.length() == 0){
		ipLine = "Dynamic";
	}

	// Add free-time policy.
	if(!isEmpty(data.ftPolicyName)){
		data.policyName += " / " + data.ftPolicyName;
	}
%>
					<tr>
						<td><%= data.opName%></td>
						<td><%= data.name%></td>
						<td><%= data.token%></td>
						<td><%= ipLine%></td>
						<td><%= data.policyName%></td>
						<td><%= data.description%></td>
						<td>
							<i class="fa fa-eye pointer-cursor" title="<%= translate("Test")%>" onclick="javascript:goUserView('<%= data.id%>')"></i>&nbsp;
						</td>
					</tr>
<%}%> 
				</tbody>
			</table>
		</div>
		<!-- /List -->

	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<!-- goForm -->
<form action="<%= getPageName()%>" name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="">
<input type="hidden" name="name" value="">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>

<script>
//-----------------------------------------------
$(document).ready(function(){
	$("#list").DataTable({
		"pageLength": 25,
		"bLengthChange" : false,
		"autoWidth" : false,
		"columnDefs": [
			{
				"targets": 6,
				"width": "50",
			}
		],
		"initComplete": function(settings, json){
			$("#loadingDiv").hide();
			$("#listDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
function goUserView(id){
	var form = document.goForm;
	form.action = "operator,user_view.jsp";
	form.id.value = id;
	form.submit();
}
</script>
