<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void resetOpReqCnt(OperatorDao dao){
	if(dao.resetOpReqCnt(paramString("name"))){
		succList.add("Update finished.");
	}
}

//-----------------------------------------------
void update(OperatorDao dao){
	// Get old data.
	OperatorData data = dao.selectOne(paramInt("id"));

	// Replace some values.
	data.id = paramInt("id");
	data.name = paramString("name");
	data.description = paramString("description");
	data.passwd = paramString("passwd");

	data.maxUser = paramInt("maxUser");
	data.maxUserIp = paramInt("maxUserIp");
	data.maxPolicy = paramInt("maxPolicy");
	data.maxWhitelist = paramInt("maxWhitelist");
	data.maxFreeTime = paramInt("maxFreeTime");

	data.email = paramString("email");
	data.alertPeriod = paramInt("alertPeriod");
	data.type = paramInt("type");
	data.stopFlag = paramBoolean("stopFlag");
	data.expDate = paramString("expDate");

	data.trialFlag = paramBoolean("trialFlag");

	// Preventing reset alert category.
	data.alertCategoryArr = null;

	// Param validation.
	if (data.alertPeriod > 0 && !isValidEmail(data.email)) {
		errList.add(translate("Invalid email address."));
		return;
	}

	if(data.trialFlag && dao.isOpTrialLicenseExpired(data.id)){
		errList.add(translate("Trial period is already finished."));
		return;
	}

	boolean resFlag = dao.update(data);

	OperatorData data2 = dao.selectOne(paramInt("id"));
	if(!data.stopFlag && data2.stopFlag){
		errList.add(translate("Operator has been suspended for having too many users."));
		return;
	}

	if(resFlag){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Check refresh without id.
if(!checkEditId("operator,operator.jsp")){
	return;
}

// Create data access object.
OperatorDao dao = new OperatorDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("resetOpReqCnt")){
	resetOpReqCnt(dao);
}

// Global.
int gOpId = paramInt("id");

// Operator data.
OperatorData data = dao.selectOne(gOpId);

// Get user list.
UserDao userDao = new UserDao(gOpId);
userDao.limit = 1000;
List<UserData> gUserList = userDao.selectList();

// Get policy list.
List<PolicyData> gPolicyList = new PolicyDao(gOpId).selectList();

// Get whitelist list.
List<WhitelistData> gWhitelist = new WhitelistDomainDao(gOpId).selectList();

// Get free-time list.
List<FreeTimeData> gFreeTimeList = new FreeTimeDao(gOpId).selectList();

// NxProxy policy.
PolicyNxProxyData gPolicyNxProxyData = new PolicyNxProxyDao(paramInt("opId")).selectOne();

// CxBlock policy.
PolicyCxBlockData gPolicyCxBlockData = new PolicyCxBlockDao(paramInt("opId")).selectOne();

// Operator request count from in-memory map.
int gOpReqCnt = dao.getOpReqCnt(data.name);
int gOpMaxReqCnt = dao.calcOpMaxReqCnt(data.maxUser, data.type);

// Active tab.
String tabActive0 = "";
String tabActive1 = "";
String tabActive2 = "";
String tabActive3 = "";
String tabActive4 = "";
String tabActive5 = "";
String tabActive6 = "";
String tabActive7 = "";

String showActive0 = "";
String showActive1 = "";
String showActive2 = "";
String showActive3 = "";
String showActive4 = "";
String showActive5 = "";
String showActive6 = "";
String showActive7 = "";

int tabIdx = paramInt("tabIdx");
if(tabIdx == 0){
	tabActive0 = " active";
	showActive0 = " show active";
}
else if(tabIdx == 1){
	tabActive1 = " active";
	showActive1 = " show active";
}
else if(tabIdx == 2){
	tabActive2 = " active";
	showActive2 = " show active";
}
else if(tabIdx == 3){
	tabActive3 = " active";
	showActive3 = " show active";
}
else if(tabIdx == 4){
	tabActive4 = " active";
	showActive4 = " show active";
}
else if(tabIdx == 5){
	tabActive5 = " active";
	showActive5 = " show active";
}
else if(tabIdx == 6){
	tabActive7 = " active";
	showActive7 = " show active";
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item clickable-li" onclick="window.location.href='operator,operator.jsp';"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item text-info"><%= translate("EDIT")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Tab -->
	<div>
		<ul class="nav nav-tabs" style="margin-left:10px; margin-right:10px;">
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(0);">
				<a class="nav-link<%= tabActive0%>" data-toggle="tab" href="#tab0"><%= translate("EDIT")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(1);">
				<a class="nav-link<%= tabActive1%>" data-toggle="tab" href="#tab1"><%= translate("USER")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(2);">
				<a class="nav-link<%= tabActive2%>" data-toggle="tab" href="#tab2"><%= translate("POLICY")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(3);">
				<a class="nav-link<%= tabActive3%>" data-toggle="tab" href="#tab3"><%= translate("WHITELIST")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(4);">
				<a class="nav-link<%= tabActive4%>" data-toggle="tab" href="#tab4"><%= translate("FREE-TIME")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(5);">
				<a class="nav-link<%= tabActive5%>" data-toggle="tab" href="#tab5">NXPROXY</a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(6);">
				<a class="nav-link<%= tabActive6%>" data-toggle="tab" href="#tab6">CXBLOCK</a>
			</li>
		</ul>
	</div>
	<!-- Tab -->

	<!-- Form -->
	<form action="<%= getPageName()%>" method="post">
		<input type="hidden" name="actionFlag" value="update">
		<input type="hidden" name="id" value="<%= data.id%>">
		<input type="hidden" id="tabIdx" name="tabIdx" value="<%= tabIdx%>">
 
		<!-- Tab content -->
		<div id="myTabContent" class="tab-content">

			<!-- Edit -->
			<div class="tab-pane <%= showActive0%>" id="tab0">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Name")%></label>
								<input type="text" class="form-control" id="name" name="name" value="<%= data.name%>" disabled>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Description")%></label>
								<input type="text" class="form-control" id="description"
									name="description" value="<%= data.description%>">
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Password")%></label>
								<input type="password" class="form-control" id="passwd"
									name="passwd" value="<%= data.passwd%>">
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max User")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of users created / The maximum number of users can be created")%>"></i>
								</label>
								<div class="input-group">
									<span class="input-group-text"><%= data.userCnt%> /</span>
									<input type="text" class="form-control" id="maxUser"
										name="maxUser" maxlength="5" value="<%= data.maxUser%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max Policy")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of policies created / The maximum number of policies can be created")%>"></i>
								</label>
								<div class="input-group">
									<span class="input-group-text"><%= data.policyCnt%> /</span>
									<input type="text" class="form-control" id="maxPolicy"
										name="maxPolicy" maxlength="5" value="<%= data.maxPolicy%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max Whitelist")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of whitelist rules created / The maximum number of whitelist rules can be created")%>"></i>
								</label>
								<div class="input-group">
									<span class="input-group-text"><%= data.whitelistCnt%> /</span>
									<input type="text" class="form-control" id="maxWhitelist"
										name="maxWhitelist" maxlength="5" value="<%= data.maxWhitelist%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max Free-time")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of free-time slots created / The maximum number of free-time slots can be created")%>"></i>
								</label>
								<div class="input-group">
									<span class="input-group-text"><%= data.freeTimeCnt%> /</span>
									<input type="text" class="form-control" id="maxFreeTime"
										name="maxFreeTime" maxlength="5" value="<%= data.maxFreeTime%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max IP Association")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of IPs associated / The maximum number of IPs can be associated")%>"></i>
								</label>
								<div class="input-group">
									<span class="input-group-text"><%= data.userIpCnt%> /</span>
									<input type="text" class="form-control" id="maxUserIp"
										name="maxUserIp" maxlength="5" value="<%= data.maxUserIp%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Email")%></label>
								<input type="text" class="form-control" id="email"
									name="email" value="<%= data.email%>">
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Alert Period")%>
									&nbsp;<i class="fa fa-question-circle south-east" title="<%= translate("For access violation emails.")%>"></i>
								</label>
								<select class="form-control" id="alertPeriod" name="alertPeriod">
<%
Map<Integer, String> periodMap = getAlertPeriodMap();
for(Map.Entry<Integer, String> entry : periodMap.entrySet()){
	Integer key = entry.getKey();
	String val = entry.getValue();

	if(key == data.alertPeriod){
		printf("<option value='%s' selected>%s</option>", key, translate(val));
	}
	else{
		printf("<option value='%s'>%s</option>", key, translate(val));
	}
}
%>
								</select>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Expiration Date")%>
										&nbsp;<i class="fa fa-question-circle south-east"
											title="<%= translate("You can set an expiration date for an operator account.")%>"></i>
								</label>
								<input type="text" class="form-control" id="expDate" name="expDate" value="<%= data.getExpDate()%>">
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Type")%></label>
								<select class="form-control" id="type" name="type">
									<option value="1" <%if(data.type == 1){out.print("selected");}%>><%= translate("Business")%></option>
									<option value="2" <%if(data.type == 2){out.print("selected");}%>><%= translate("Home")%></option>
								</select>
							</div>

							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="trialFlag"
										name="trialFlag" <%if(data.trialFlag){out.print("checked");}%>>
									<label class="custom-control-label" for="trialFlag">
										<%= translate("Trial Account")%>
										&nbsp;<i class="fa fa-question-circle south-east"
											title="<%= translate("Trial account will be suspended after 30 days from its creation date. You only can make it a trial account within 30 days from its creation date.")%>"></i>
											, <%= translateF("Created at %s, %s days left", data.getCreationDate(), data.getTrialDaysLeft())%>
									</label>
								</div>
							</div>

							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="stopFlag"
										name="stopFlag" <%if(data.stopFlag){out.print("checked");}%>>
									<label class="custom-control-label" for="stopFlag">
										<%= translate("Suspend")%>
										&nbsp;<i class="fa fa-question-circle south-east" title="<%= translate("You can suspend operator account.")%>"></i>
									</label>
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("DNS Request Count")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of DNS requests sent / The maximum number of DNS requests can be sent")%>"></i>
								</label>
								<div class="input-group">
									<span class="input-group-text"><%= gOpReqCnt%> /</span>
									<input type="text" class="form-control" value="<%= gOpMaxReqCnt%>" disabled>
								</div>
							</div>

							<div class="form-group col-lg-8">
								<button type="button" class="btn btn-primary" onclick="javascript:actionUpdate(this.form);"><%= translate("SUBMIT")%></button>
								<button type="button" class="btn btn-warning" onclick="javascript:actionResetOpReqCnt();"><%= translate("RESET DNS REQUEST COUNT")%></button>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Edit -->

			<!-- User -->
			<div class="tab-pane fade<%= showActive1%>" id="tab1">
				<div id="userListDiv" class="container-fluid" style="display: none;">
					<table id="userList" class="cell-border hover" style="width:100%">
						<thead>
							<tr>
								<th><%= translate("Name")%></th>
								<th><%= translate("IP")%></th>
								<th><%= translate("Work-time Policy")%></th>
								<th><%= translate("Free-time Policy")%></th>
								<th><%= translate("Description")%></th>
								<th></th>
							</tr>
						</thead>
						<tbody>
<%
for(int i = 0; i < gUserList.size(); i++){
	UserData dx = gUserList.get(i);

	String name = dx.name;
	if(dx.systemFlag){
		name = "*" + name;
	}

	String ipLine = dx.getIpLine();
	if(ipLine.length() > 30){
		ipLine = ipLine.substring(0, 30) + "..";
	}

	if(ipLine.length() == 0){
		ipLine = "Dynamic";
	}
%>
							<tr>
								<td><%= name%></td>
								<td><%= ipLine%></td>
								<td><%= dx.policyName%></td>
								<td><%= dx.ftPolicyName%></td>
								<td><%= dx.description%></td>
								<td>
									<i class="fa fa-eye" style="cursor:pointer" title="<%= translate("View")%>"
										onclick="javascript:goUserView(<%= dx.id%>)"></i>
								</td>
							</tr>
<%}%> 
						</tbody>
					</table>
				</div>
			</div>
			<!-- /User -->

			<!-- Policy -->
			<div class="tab-pane fade<%= showActive2%>" id="tab2">
				<div id="policyListDiv" class="container-fluid" style="display: none;">
					<table id="policyList" class="cell-border hover" style="width:100%">
						<thead>
							<tr>
								<th><%= translate("Name")%></th>
								<th><%= translate("Description")%></th>
								<th></th>
							</tr>
						</thead>
						<tbody>
<%
for(int i = 0; i < gPolicyList.size(); i++){
	PolicyData dx = gPolicyList.get(i);

	String name = dx.name;
	if(dx.systemFlag){
		name = "*" + name;
	}
%>
							<tr>
								<td><%= name%></td>
								<td><%= dx.description%></td>
								<td>
									<i class="fa fa-eye" style="cursor:pointer" title="<%= translate("View")%>"
										onclick="javascript:goPolicyView(<%= dx.id%>)"></i>
								</td>
							</tr>
<%}%> 
						</tbody>
					</table>
				</div>
			</div>
			<!-- /Policy -->

			<!-- Whitelist -->
			<div class="tab-pane fade<%= showActive3%>" id="tab3">
				<div id="wrListDiv" class="container-fluid" style="display: none;">
					<table id="wrList" class="cell-border hover" style="width:100%">
						<thead>
							<tr>
								<th><%= translate("Domain")%></th>
								<th><%= translate("Flags")%></th>
								<th><%= translate("Applied policies")%></th>
							</tr>
						</thead>
						<tbody>
<%
for(int i = 0; i < gWhitelist.size(); i++){
	WhitelistData dx = gWhitelist.get(i);
%>
							<tr>
								<td><%= dx.domain%></td>
								<td><%= dx.getFlagLine()%></td>
								<td><%= dx.getAppliedPolicyLine()%></td>
							</tr>
<%}%> 
						</tbody>
					</table>
				</div>
			</div>
			<!-- /Whitelist -->

			<!-- Free-time -->
			<div class="tab-pane fade<%= showActive4%>" id="tab4">
				<div id="ftListDiv" class="container-fluid" style="display: none;">
					<table id="ftList" class="cell-border hover" style="width:100%">
						<thead>
							<tr>
								<th><%= translate("Time")%></th>
								<th><%= translate("Day of Week")%></th>
								<th><%= translate("Description")%></th>
							</tr>
						</thead>
						<tbody>
<%
for(int i = 0; i < gFreeTimeList.size(); i++){
	FreeTimeData dx = gFreeTimeList.get(i);
%>
							<tr>
								<td><%= dx.stime%> ~ <%= dx.etime%></td>
								<td><%= dx.getWdayLine()%></td>
								<td><%= dx.description%></td>
							</tr>
<%}%> 
						</tbody>
					</table>
				</div>
			</div>
			<!-- /Free-time -->

			<!-- NxProxy for Windows -->
			<div class="tab-pane fade<%= showActive5%>" id="tab5">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">

						<div class="form-group col-lg-8">
							<div class="custom-control custom-checkbox">
								<input type="checkbox" class="custom-control-input" id="enableFilter"
									name="enableFilter" <%if(gPolicyNxProxyData.enableFilter){out.print("checked");}%>>
								<label for="enableFilter" class="custom-control-label"><%= translate("Enable Filter")%></label>
							</div>
						</div>
						<div class="form-group col-lg-8">
							<label class="col-form-label">
								<%= translate("Local Domain")%>
							</label>
							<textarea class="form-control" id="localDomain" name="localDomain"><%= gPolicyNxProxyData.localDomain%></textarea>
						</div>
						<div class="form-group col-lg-8">
							<label class="col-form-label">
								<%= translate("Local DNS Server")%>
							</label>
							<input type="text" class="form-control" id="localDns" name="localDns"
								value="<%= gPolicyNxProxyData.localDns%>">
						</div>

					</div>
				</div>
			</div>
			<!-- /NxProxy for Windows -->

			<!-- NxProxy for Android
			<div class="tab-pane fade<%= showActive6%>" id="tab6">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">

						<div class="form-group col-lg-8">
							<div class="custom-control custom-checkbox">
								<input type="checkbox" class="custom-control-input" id="enableFilter"
									name="enableAndroid" <%if(gPolicyNxProxyData.enableAndroid){out.print("checked");}%>>
								<label for="enableAndroid" class="custom-control-label"><%= translate("Enable Filter")%></label>
							</div>
						</div>
						<div class="form-group col-lg-8">
							<label class="col-form-label">
								<%= translate("Bypassed Android Apps")%>
							</label>
							<textarea class="form-control" id="bypassedPackages" name="bypassedPackages" rows="10"><%= gPolicyNxProxyData.bypassedPackages%></textarea>
						</div>

					</div>
				</div>
			</div>
			 -->
			<!-- /NxProxy for Android -->

			<!-- CxBlock -->
			<div class="tab-pane fade<%= showActive6%>" id="tab6">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">

						<div class="form-group col-lg-8">
							<div class="custom-control custom-checkbox">
								<input type="checkbox" class="custom-control-input" id="enableFilter"
									name="enableFilter" <%if(gPolicyCxBlockData.enableFilter){out.print("checked");}%>>
								<label for="enableFilter" class="custom-control-label"><%= translate("Enable Filter")%></label>
							</div>
						</div>
						<div class="form-group col-lg-8">
							<label class="col-form-label">
								<%= translate("Query Cache TTL")%>
							</label>
							<div class="input-group">
								<input type="text" class="form-control" id="cacheTtl"
									name="cacheTtl" value="<%= gPolicyCxBlockData.cacheTtl%>">
								<div class="input-group-append">
									<span class="input-group-text">seconds, 60 ~ 3600</span>
								</div>				
							</div>
						</div>
						<div class="form-group col-lg-8">
							<label class="col-form-label">
								<%= translate("Blocked Keywords in URL")%>
							</label>
							<textarea class="form-control" id="blockedKeyword" name="blockedKeyword" rows="18"><%= gPolicyCxBlockData.blockedKeyword%></textarea>
						</div>

					</div>
				</div>
			</div>
			<!-- /CxBlock -->

		</div>
		<!-- Tab content -->

	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<!-- goForm -->
<form action="" name="goForm" method="get">
<input type="hidden" name="mode" value="">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="">
<input type="hidden" name="name" value="">
<input type="hidden" name="opId" value="<%= data.id%>">
<input type="hidden" name="opName" value="<%= data.name%>">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>

<script>
//-----------------------------------------------
$(document).ready(function(){
	$("#userList").DataTable({
		"bFilter" : false,
		"paging" : false,
		"ordering" : false,
		"info" : true,
		"autoWidth" : false,
		"columnDefs": [{
			"targets": 5,
			"width": "80"
		}],
		"initComplete": function(settings, json){
			$("#userListDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
$(document).ready(function(){
	$("#policyList").DataTable({
		"bFilter" : false,
		"paging" : false,
		"ordering" : false,
		"info" : true,
		"autoWidth" : false,
		"columnDefs": [{
			"targets": 2,
			"width": "80"
		}],
		"initComplete": function(settings, json){
			$("#policyListDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
$(document).ready(function(){
	$("#wrList").DataTable({
		"bFilter" : false,
		"paging" : false,
		"ordering" : false,
		"info" : true,
		"autoWidth" : false,
		"columnDefs": [{
			"targets": 0,
			"width": "200"
		}],
		"initComplete": function(settings, json){
			$("#wrListDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
$(document).ready(function(){
	$("#ftList").DataTable({
		"bFilter" : false,
		"paging" : false,
		"ordering" : false,
		"info" : true,
		"autoWidth" : false,
		"columnDefs": [{
			"targets": 0,
			"width": "200"
		}],
		"initComplete": function(settings, json){
			$("#ftListDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
// Restricts input for each element in the set of matched elements to the given inputFilter.
(function($) {
	$.fn.inputFilter = function(inputFilter){
		return this.on("input keydown keyup mousedown mouseup select contextmenu drop", function(){
			if (inputFilter(this.value)){
				this.oldValue = this.value;
				this.oldSelectionStart = this.selectionStart;
				this.oldSelectionEnd = this.selectionEnd;
			} else if (this.hasOwnProperty("oldValue")){
				this.value = this.oldValue;
				this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
			} else {
				this.value = "";
			}
		});
	};
}(jQuery));


// Install input filters.
$("#maxUser").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value);
});
$("#maxUserIp").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value);
});
$("#maxPolicy").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value);
});
$("#maxWhitelist").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value);
});
$("#maxFreeTime").inputFilter(function(value){
	if(value == ""){
		return true;
	}

	return /^\d*$/.test(value);
});

//-----------------------------------------------
var dateToDisable = new Date();
jQuery("#expDate").datetimepicker({
	format: "<%= getGuiDateFormatForPicker()%>",
	step: 1,
	timepicker: false,
	beforeShowDay: function(date) {
		if (date.getTime() < dateToDisable.getTime()) {
			return [false, ""]
		}

		return [true, ""];
	}
});

//-----------------------------------------------
function actionResetOpReqCnt(){
	if(!confirm('<%= translate("Reset DNS request count?")%>')){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "resetOpReqCnt";
	form.id.value = <%= data.id%>;
	form.name.value = "<%= data.name%>";
	form.submit();
}

//-----------------------------------------------
function actionUpdate(form){
	form.actionFlag.value = "update";
	form.submit();
}

//-----------------------------------------------
function goUserView(id){
	var form = document.goForm;
	form.action = "operator,user_view.jsp";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
function goPolicyView(id){
	var form = document.goForm;
	form.action = "operator,policy_view.jsp";
	form.id.value = id;
	form.submit();
}
</script>
