<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void insert(OperatorDao dao){
	OperatorData data = new OperatorData();
	data.name = paramString("name");
	data.type = paramInt("type");
	data.description = paramString("description");
	
	// We use name of the user as the initial password.
	data.passwd = paramString("name");

	// Set default value.
	LicensePolicyData lpData = new LicensePolicyDao().selectOne();
	data.maxUser = lpData.maxUser;
	data.maxUserIp = lpData.maxUserIp;
	data.maxPolicy = lpData.maxPolicy;
	data.maxWhitelist = lpData.maxWhitelist;
	data.maxFreeTime = lpData.maxFreeTime;

	// Default value for home operator.
	if(data.type == OperatorData.TYPE_HOME){
		data.maxUser = 1;
	}

	// Param validation.
	if(!ParamTest.isValidNameLen(data.name)){
		errList.add(ParamTest.ERR_NAME_LEN);
		return;
	}
	
	if(!ParamTest.isValidUsernameChar(data.name)){
		errList.add(ParamTest.ERR_USERNAME_CHAR);
		return;
	}

	if (ParamTest.isDupOperator(data.name)) {
		errList.add(translate("Operator already exists."));
		return;
	}

	if (ParamTest.isDupUser(data.name)) {
		errList.add(translate("User already exists."));
		return;
	}

	if(ParamTest.testMaxLicenseUser(data.maxUser)){
		errList.add(translate("Can't add more user."));
		return;
	}

	if(dao.insert(data)){
		succList.add(translate("Update finished."));
	}
}

//-----------------------------------------------
void delete(OperatorDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	if(dao.delete(paramInt("id"))){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
OperatorDao dao = new OperatorDao();
dao.limit = 10000;

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("insert")){
	insert(dao);
}
if(actionFlag.equals("delete")){
	delete(dao);
}

// Global.
int gCount = dao.selectCount();
int gTrialCount = dao.selectTrialCount();
int gSuspendedCount = dao.selectSuspendedCount();
int gPage = dao.page;
int gLimit = dao.limit;
String gKw = paramString("kw");

OperatorData sumData = dao.selectSum();

// Active tab.
String tabActive0 = "";
String tabActive1 = "";

String showActive0 = "";
String showActive1 = "";

int tabIdx = paramInt("tabIdx");
if(tabIdx == 0){
	tabActive0 = " active";
	showActive0 = " show active";
}
else if(tabIdx == 1){
	tabActive0 = " active";
	showActive0 = " show active";
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item text-info"><%= translate("OPERATOR")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Tab -->
	<div>
		<ul class="nav nav-tabs" style="margin-left:10px; margin-right:10px;">
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(0);">
				<a class="nav-link<%= tabActive0%>" data-toggle="tab" href="#tab0"><%= translate("LIST")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(1);">
				<a class="nav-link<%= tabActive1%>" data-toggle="tab" href="#tab1"><%= translate("CREATE")%></a>
			</li>
		</ul>
	</div>
	<!-- Tab -->

	<!-- Form -->
	<form action="<%= getPageName()%>" method="post">
		<input type="hidden" name="actionFlag" value="insert">
		<input type="hidden" id="tabIdx" name="tabIdx" value="<%= tabIdx%>">

		<!-- Tab content -->
		<div id="myTabContent" class="tab-content">

			<!-- List -->
			<div class="tab-pane <%= showActive0%>" id="tab0">
				<div id="loadingDiv" class="container-fluid" style="display: block;">
					<table class="cell-border hover" style="width: 100%">
						<tr height="500">
							<td width="100%" align="center" valign="center">
								<img src="img/loading.gif?<%= new Random().nextInt(10000)%>">
							</td>
						<tr>
					</table>
				</div>
				<div id="listDiv" class="container-fluid" style="display: none;">
					<table id="list" class="cell-border hover" style="width:100%">
						<thead>
							<tr>
								<th><%= translate("Name")%></th>
								<th><%= translate("User")%></th>
								<th><%= translate("Policy")%></th>
								<th><%= translate("Whitelist")%></th>
								<th><%= translate("Free-time")%></th>
								<th><%= translate("IP Association")%></th>
								<th><%= translate("Expiration")%></th>
								<th><%= translate("Type")%></th>
								<th><%= translate("Description")%></th>
								<th></th>
							</tr>
						</thead>
						<thead>
							<tr>
								<td>*Sum</td>
								<td>
									<%= sumData.userCnt%>/ <%= sumData.maxUser%> / <%= sumData.maxUserActive%> / <%= sumData.maxUserTrial%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of users created by all operators")%>
										<br>/ <%= translate("The number of users allocated to all operators")%>
										<br>/ <%= translate("The number of users allocated to all active (not suspended) operators")%>
										<br>/ <%= translate("The number of users allocated to all trial operators")%>
									"></i>
								</td>
								<td>
									<%= sumData.policyCnt%> / <%= sumData.maxPolicy%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of policies created by all operators")%>
										<br>/ <%= translate("The number of policies that can be created by all operators")%>
									"></i>
								</td>
								<td>
									<%= sumData.whitelistCnt%> / <%= sumData.maxWhitelist%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of whitelist rules created by all operators")%>
										<br>/ <%= translate("The number of whitelist rules that can be created by all operators")%>
									"></i>
								</td>
								<td>
									<%= sumData.freeTimeCnt%> / <%= sumData.maxFreeTime%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of free-time slots created by all operators")%>
										<br>/ <%= translate("The number of free-time slots that can be created by all operators")%>
									"></i>
								</td>
								<td>
									<%= sumData.userIpCnt%> / <%= sumData.maxUserIp%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of IPs associated by all operators")%>
										<br>/ <%= translate("The number of IPs that can be associated by all operators")%>
									"></i>								
								</td>
								<td></td>
								<td></td>
								<td></td>
								<td></td>
							</tr>
						</thead>
						<tbody>

<%
List<OperatorData> dataList = dao.selectList();
for(int i = 0; i < dataList.size(); i++){
	OperatorData data = dataList.get(i);

	String nameStyle = "";
	if(data.stopFlag || data.isExpired()){
		nameStyle = "text-decoration:line-through;";
	}

	String typeStr = "Business";
	if(data.type == OperatorData.TYPE_HOME){
		typeStr = "Home";
	}

	String showTrial = "";
	if(data.trialFlag){
		showTrial = " - T";
	}
%>
							<tr>
								<td style="<%= nameStyle%>"><%= data.name%><%= showTrial%></td>
								<td><%= data.userCnt%> / <%= data.maxUser%></td>
								<td><%= data.policyCnt%>  / <%= data.maxPolicy%></td>
								<td><%= data.whitelistCnt%>  / <%= data.maxWhitelist%></td>
								<td><%= data.freeTimeCnt%>  / <%= data.maxFreeTime%></td>
								<td><%= data.userIpCnt%> / <%= data.maxUserIp%></td>
								<td><%= data.getExpDate()%></td>
								<td><%= typeStr%></td>
								<td><%= data.description%></td>
								<td>
									<i class="fa fa-pencil-square" style="cursor:pointer" title="<%= translate("Edit")%>" onclick="javascript:goEdit(<%= data.id%>)"></i>&nbsp;
									<i class="fa fa-trash" style="cursor:pointer" title="<%= translate("Delete")%>" onclick="javascript:actionDelete(<%= data.id%>, '<%= data.name%>')"></i>
								</td>
							</tr>
<%}%> 
						</tbody>
					</table>
				</div>
			</div>
			<!-- /List -->

			<!-- CREATE -->
			<div class="tab-pane fade<%= showActive1%>" id="tab1">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Name")%></label>
								<input type="text" class="form-control" id="name" name="name">
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Description")%></label>
								<input type="text" class="form-control" id="description" name="description" >
							</div>
							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			<!-- /CREATE -->

		</div>
		<!-- Tab content -->

	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<!-- goForm -->
<form action="<%= getPageName()%>" name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="">
<input type="hidden" name="name" value="">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>

<script>
//-----------------------------------------------
$(document).ready(function(){
	$("#list").DataTable({
		"pageLength": 25,
		"bLengthChange" : false,
		"autoWidth" : false,
		"columnDefs": [{
			"targets": 6,
			"width": "50"
		}],
		"initComplete": function(settings, json){
			$("#loadingDiv").hide();
			$("#listDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
function actionDelete(id, name){
	if(!confirm('<%= translate("Deleting operator")%> : ' + name)){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "delete";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
function goEdit(id){
	var form = document.goForm;
	form.action = "operator,operator_edit.jsp";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
// Prevent submit again.
if(window.history.replaceState){
	window.history.replaceState(null, null, window.location.href);
}
</script>
