<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(LicensePolicyDao dao){
	LicensePolicyData data = new LicensePolicyData();

	data.onLicenseViolation = paramInt("onLicenseViolation");
	data.beforeLicenseExpiration = paramInt("beforeLicenseExpiration");
	data.onTrialExpiration = paramInt("onTrialExpiration");
	data.useTrialPeriod = paramBoolean("useTrialPeriod");
	data.onSignupRequest = paramInt("onSignupRequest");
	data.onSignupApproval = paramInt("onSignupApproval");

	data.maxUser = paramInt("maxUser");
	data.maxUserIp = paramInt("maxUserIp");
	data.maxPolicy = paramInt("maxPolicy");
	data.maxWhitelist = paramInt("maxWhitelist");
	data.maxFreeTime = paramInt("maxFreeTime");

	// Update it.
	if(dao.update(data)){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
LicensePolicyDao dao = new LicensePolicyDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
LicensePolicyData data = dao.selectOne();

// Active tab.
String tabActive0 = "";
String tabActive1 = "";

String showActive0 = "";
String showActive1 = "";

int tabIdx = paramInt("tabIdx");
if(tabIdx == 0){
	tabActive0 = " active";
	showActive0 = " show active";
}
else if(tabIdx == 1){
	tabActive1 = " active";
	showActive1 = " show active";
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("OPERATOR")%></li>
		<li class="breadcrumb-item text-info"><%= translate("LICENSE POLICY")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Tab -->
	<div>
		<ul class="nav nav-tabs" style="margin-left:10px; margin-right:10px;">
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(0);">
				<a class="nav-link<%= tabActive0%>" data-toggle="tab" href="#tab0"><%= translate("LICENSE POLICY")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(1);">
				<a class="nav-link<%= tabActive1%>" data-toggle="tab" href="#tab1"><%= translate("LICENSE DEFAULTS")%></a>
			</li>
		</ul>
	</div>
	<!-- Tab -->

	<!-- Form -->
	<form action="<%= getPageName()%>" method="post">
		<input type="hidden" name="actionFlag" value="update">
		<input type="hidden" id="tabIdx" name="tabIdx" value="<%= tabIdx%>">
 
		<!-- Tab content -->
		<div id="myTabContent" class="tab-content">

			<!-- License Policy -->
			<div class="tab-pane <%= showActive0%>" id="tab0">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>
							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("On License Violation")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("When there is a 'Too many requests' license violation for an operator, you can bypass filtering service for the operator or just send a warning email.")%>"></i>
								</label>
								<select class="form-control" id="onLicenseViolation" name="onLicenseViolation">
									<option value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
										<%if(data.onLicenseViolation == LicensePolicyData.ACTION_DO_NOTHING){out.print("selected");}%>><%= translate("Do nothing")%></option>
									<option value="<%= LicensePolicyData.ACTION_SEND_EMAIL%>"
										<%if(data.onLicenseViolation == LicensePolicyData.ACTION_SEND_EMAIL){out.print("selected");}%>><%= translate("Warning email")%></option>
									<option value="<%= LicensePolicyData.ACTION_BYPASS_FILTER%>"
										<%if(data.onLicenseViolation == LicensePolicyData.ACTION_BYPASS_FILTER){out.print("selected");}%>>
											<%= translate("Warning email and bypass filtering")%></option>
								</select>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("On Account Expiration")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("You can send warning emails to operators before their accounts expired. The warning emails will be sent on every third day from 15 days before the expiration date.")%>"></i>
								</label>
								<select class="form-control" id="beforeLicenseExpiration" name="beforeLicenseExpiration">
									<option value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
										<%if(data.beforeLicenseExpiration == LicensePolicyData.ACTION_DO_NOTHING){out.print("selected");}%>><%= translate("Do nothing")%></option>
									<option value="<%= LicensePolicyData.ACTION_SEND_EMAIL%>"
										<%if(data.beforeLicenseExpiration == LicensePolicyData.ACTION_SEND_EMAIL){out.print("selected");}%>><%= translate("Warning email")%></option>
								</select>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("On Trial Expiration")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("You can suspend an operator account when his trial period expires. When you suspend an oprator account, all the requests from the operator will be blocked.")%>"></i>
								</label>
								<select class="form-control" id="onTrialExpiration" name="onTrialExpiration">
									<option value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
										<%if(data.onTrialExpiration == LicensePolicyData.ACTION_DO_NOTHING){out.print("selected");}%>><%= translate("Do nothing")%></option>
									<option value="<%= LicensePolicyData.ACTION_SUSPEND_ACCT%>"
										<%if(data.onTrialExpiration == LicensePolicyData.ACTION_SUSPEND_ACCT){out.print("selected");}%>><%= translate("Suspend account")%></option>
								</select>
							</div>

							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="useTrialPeriod"
										name="useTrialPeriod" <%if(data.useTrialPeriod){out.print("checked");}%>>
									<label for="useTrialPeriod" class="custom-control-label">
										<%= translate("Use Trial Period")%>
										&nbsp;<i class="fa fa-question-circle south-east"
											title="<%= translate("With this option enabled, a new operator will be in 30 days trial period.")%>"></i>
									</label>
								</div>
							</div>
							
							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("On Signup Request")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("If you don't need the approval process for a signup request and want to create operators at their signup time automatically, select 'Create a new operator'.")%>"></i>
								</label>
								<select class="form-control" id="onSignupRequest" name="onSignupRequest">
									<option value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
										<%if(data.onSignupRequest == LicensePolicyData.ACTION_DO_NOTHING){out.print("selected");}%>><%= translate("Do nothing")%></option>
									<option value="<%= LicensePolicyData.ACTION_CREATE_OPERATOR%>"
										<%if(data.onSignupRequest == LicensePolicyData.ACTION_CREATE_OPERATOR){out.print("selected");}%>>
											<%= translate("Create a new operator")%></option>
								</select>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("On Signup Approval")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("You can send a notification email to new operators for when their signup requests approved.")%>"></i>
								</label>
								<select class="form-control" id="onSignupApproval" name="onSignupApproval">
									<option value="<%= LicensePolicyData.ACTION_DO_NOTHING%>"
										<%if(data.onSignupApproval == LicensePolicyData.ACTION_DO_NOTHING){out.print("selected");}%>><%= translate("Do nothing")%></option>
									<option value="<%= LicensePolicyData.ACTION_SEND_EMAIL%>"
										<%if(data.onSignupApproval == LicensePolicyData.ACTION_SEND_EMAIL){out.print("selected");}%>>
											<%= translate("Notification email")%></option>
								</select>
							</div>

							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
							</div>

						</fieldset>
					</div>
				</div>
			</div>
			<!-- /License Policy -->

			<!-- Operator Default -->
			<div class="tab-pane fade<%= showActive1%>" id="tab1">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max User")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of users can be created by an operator.")%>"></i>
								</label>
								<div class="input-group">
									<input type="text" class="form-control" id="maxUser"
										name="maxUser" maxlength="4" value="<%= data.maxUser%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max Policy")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of policies can be created by an operator.")%>"></i>
								</label>
								<div class="input-group">
									<input type="text" class="form-control" id="maxPolicy"
										name="maxPolicy" maxlength="4" value="<%= data.maxPolicy%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max Whitelist")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of whitelist rules can be created by an operator.")%>"></i>
								</label>
								<div class="input-group">
									<input type="text" class="form-control" id="maxWhitelist"
										name="maxWhitelist" maxlength="4" value="<%= data.maxWhitelist%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max Free-time")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of free-time slots can be created by an operator.")%>"></i>
								</label>
								<div class="input-group">
									<input type="text" class="form-control" id="maxFreeTime"
										name="maxFreeTime" maxlength="4" value="<%= data.maxFreeTime%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Max IP Association")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("The number of IPs can be associated by an operator.")%>"></i>
								</label>
								<div class="input-group">
									<input type="text" class="form-control" id="maxUserIp"
										name="maxUserIp" maxlength="4" value="<%= data.maxUserIp%>">
								</div>
							</div>

							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
							</div>

						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Operator Default -->

		</div>
		<!-- Tab content -->

	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<%@include file="include/footer.jsp"%>
