<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void insert(JahaslistDao dao){
	JahaslistData data = new JahaslistData();
	data.domain = paramString("domain");
	data.categoryId = paramInt("categoryId");

	// Param validation.
	if(isEmpty(data.domain)){
		return;
	}

    if(data.categoryId == 0){
		errList.add("Invalid category.");
		return;
	}

	String[] arr = data.domain.split("\\s+");
	for(String domain : arr){
		domain = domain.trim();

		if(!isValidDomain(domain)){
			if(errList.size() < 5){
				errList.add("Invalid domain. - " + domain);
			}
			continue;
		}
	}

	if(dao.insert(data)){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
JahaslistDao dao = new JahaslistDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("insert")){
	insert(dao);
}

// Global.
int gCount = dao.selectCount();
if(dao.selectCount() < 2000000){
	warnList.add(translate("Jahaslist size is too small. You may have an incomplete update."));
}

String[] gUpdateInfoArr = dao.getUpdateInfoArr();
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("CLASSIFIER")%></li>
		<li class="breadcrumb-item text-info"><%= translate("JAHASLIST")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Form -->
<div class="container-fluid">
	<div class="card bg-light m-2 expand-lg">
		<div class="card-body">
			<form action="<%= getPageName()%>" method="post">
				<input type="hidden" name="actionFlag" value="insert">
				<div class="form-group col-lg-8 text-secondary">
					<%
						String tLine = translate("You can add domains into Jahaslist directly. We have %s domains classified at the moment.");
						printf(tLine, NumberFormat.getIntegerInstance().format(gCount));
					%>
					<%if(gUpdateInfoArr != null && gUpdateInfoArr.length >= 2 ){%>
						<small id="input-help" class="form-text text-info">
							Last update : <%= gUpdateInfoArr[0]%> / Version : <%= gUpdateInfoArr[1]%>
						</small>
					<%}%>
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("Domain")%>
						&nbsp;<i class="fa fa-question-circle south-east"
							title="<%= translate("Multiple domains must be separated by spaces or newlines.")%>"></i>
					</label>
					<textarea class="form-control" id="domain" name="domain" rows="4"></textarea>
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label"><%= translate("Category")%></label>
					<select class="form-control" id="categoryId" name="categoryId">
						<option value="0"><%= translate("SELECT CATEGORY")%></option>
<%
Map<Integer,String> jahasCategoryMap = dao.getJahasCategoryMap();
for(Map.Entry<Integer,String> entry : jahasCategoryMap.entrySet()){
	int categoryId = entry.getKey();
	String categoryName = entry.getValue();
	printf("<option value='%s'>%s", categoryId, translate(categoryName));
}
%>
					</select>
				</div>

				<div class="form-group col-lg-8">
					<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- /Form -->

<!-- goForm -->
<form name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>
