/*
 * Decompiled with CFR 0.152.
 */
package nxd.data;

import java.util.HashMap;
import java.util.Map;
import nxd.data.FirstData;
import nxd.data.PolicyData;
import nxd.lib.c;

public class WhitelistData
extends FirstData {
    public int id = 0;
    public String domain = "";
    public String keyword = "";
    public String description = "";
    public boolean bypassAuth = false;
    public boolean bypassFilter = false;
    public boolean bypassLog = false;
    public boolean adminBlock = false;
    public boolean dropPacket = false;
    public Map<Integer, PolicyData> appliedPolicyMap = new HashMap<Integer, PolicyData>();
    public String[] appliedPolicyArr = new String[0];

    public String getFlagLine() {
        String string = "";
        if (this.bypassFilter) {
            string = string + ", bypass_filter";
        }
        if (this.bypassLog) {
            string = string + ", bypass_log";
        }
        if (this.adminBlock) {
            string = string + ", admin_block";
        }
        if (this.dropPacket) {
            string = string + ", drop_packet";
        }
        string = string.replaceFirst("^, ", "");
        return string;
    }

    public String getAppliedPolicyLine() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (PolicyData policyData : this.appliedPolicyMap.values()) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(policyData.name);
            ++n2;
        }
        Object object = stringBuilder.toString().replaceFirst("^, ", "");
        if (((String)object).length() == 0) {
            object = "Global";
        }
        return object;
    }

    public boolean isAppliedPolicy(int n2) {
        return this.appliedPolicyMap.containsKey(n2);
    }

    @Override
    public void sanitize() {
        this.domain = c.a(this.domain, 255).toLowerCase();
        this.keyword = c.a(this.keyword, 64).toLowerCase();
        if (this.adminBlock) {
            this.bypassFilter = false;
        }
        this.bypassAuth = false;
    }

    public String toString() {
        return "WhitelistData{id=" + this.id + ", domain=" + this.domain + ", keyword=" + this.keyword + ", description=" + this.description + ", bypassAuth=" + this.bypassAuth + ", bypassFilter=" + this.bypassFilter + ", bypassLog=" + this.bypassLog + ", adminBlock=" + this.adminBlock + ", dropPacket=" + this.dropPacket + ", appliedPolicyArr=" + String.join((CharSequence)",", this.appliedPolicyArr) + '}';
    }
}

