/*
 * Decompiled with CFR 0.152.
 */
package nxd.data;

import java.util.ArrayList;
import java.util.List;
import nxd.data.CategoryData;
import nxd.data.FirstData;
import nxd.l.g;
import nxd.lib.c;
import nxd.lib.d;

public class OperatorData
extends FirstData {
    public static final int TYPE_BUSINESS = 1;
    public static final int TYPE_HOME = 2;
    public int id = 0;
    public String name = "";
    public String description = "";
    public String passwd = "";
    public boolean stopFlag = false;
    public String email = "";
    public int alertPeriod = 0;
    public int maxUser = 0;
    public int maxUserIp = 0;
    public int maxPolicy = 0;
    public int maxWhitelist = 0;
    public int maxFreeTime = 0;
    public int userCnt = 0;
    public int userIpCnt = 0;
    public int policyCnt = 0;
    public int whitelistCnt = 0;
    public int freeTimeCnt = 0;
    public String expDate = "";
    public String ctime = "";
    public boolean trialFlag = false;
    public int type = 1;
    public String alertCategory = "";
    public List<CategoryData> alertCategoryList = new ArrayList<CategoryData>();
    public String[] alertCategoryArr = new String[0];
    public int maxUserActive = 0;
    public int maxUserTrial = 0;
    public boolean recvAlertAdminBlock = true;
    public boolean recvAlertCategoryBlock = true;
    public boolean recvAlertUnclassified = true;
    public boolean recvAlertBlockTime = true;
    public boolean recvAlertSystemBlock = true;
    public boolean recvAlertOtherReasons = true;

    @Override
    public void sanitize() {
        this.name = c.a(this.name, 64);
        this.description = c.a(this.description, 100);
        this.maxUser = c.a(this.maxUser, 1, 10000);
        this.maxUserIp = c.a(this.maxUserIp, 1, 10000);
        this.maxPolicy = c.a(this.maxPolicy, 1, 1000);
        this.maxWhitelist = c.a(this.maxWhitelist, 1, 1000);
        this.maxFreeTime = c.a(this.maxFreeTime, 3, 1000);
        this.alertPeriod = this.alertPeriod < 0 ? 0 : this.alertPeriod;
        this.expDate = g.d(this.expDate);
        this.expDate = this.expDate.replaceAll("\\D", "");
        if (this.type < 1 || this.type > 2) {
            this.type = 1;
        }
        if (this.type == 2 && this.maxUser > 10) {
            this.maxUser = 10;
        }
        if (this.alertCategoryArr != null) {
            this.alertCategory = c.a(this.alertCategoryArr, ",");
        }
    }

    public String getExpDate() {
        String string = "";
        if (this.trialFlag && c.b(string = OperatorData.getTrialExpDate(this.ctime))) {
            string = c.a(string, 8);
        }
        if (c.b(string) && c.a(this.expDate)) {
            return g.a(string);
        }
        if (c.b(this.expDate) && c.a(string)) {
            return g.a(this.expDate);
        }
        if (this.expDate.compareTo(string) < 0) {
            return g.a(this.expDate);
        }
        return g.a(string);
    }

    public boolean isExpired() {
        return c.b(this.expDate) && d.a("yyyyMMdd").compareTo(this.expDate) > 0;
    }

    public String getCreationDateOld() {
        String string = "";
        if (!c.a(this.ctime)) {
            string = d.b("yyyyMMddHHmm", "yyyy/MM/dd HH:mm", this.ctime);
        }
        return string;
    }

    public String getCreationDate() {
        String string = "";
        if (!c.a(this.ctime)) {
            string = g.b(this.ctime);
        }
        return string;
    }

    public static String getTrialExpDate(String string) {
        string = c.a(string, 8);
        return d.c("yyyyMMdd", string, 30);
    }

    public static int calcTrialDaysLeft(String string) {
        String string2;
        String string3 = OperatorData.getTrialExpDate(string);
        int n2 = d.c("yyyyMMdd", string3, string2 = d.a("yyyyMMdd"));
        return n2 > 0 ? n2 : 0;
    }

    public int getTrialDaysLeft() {
        return OperatorData.calcTrialDaysLeft(this.ctime);
    }

    public String toString() {
        return "OperatorData{id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", passwd=" + this.passwd + ", stopFlag=" + this.stopFlag + ", expDate=" + this.expDate + ", email=" + this.email + ", alertPeriod=" + this.alertPeriod + ", maxUser=" + this.maxUser + ", maxUserIp=" + this.maxUserIp + ", maxPolicy=" + this.maxPolicy + ", max_whitelist=" + this.maxWhitelist + ", maxFreeTime=" + this.maxFreeTime + ", userCnt=" + this.userCnt + ", userIpCnt=" + this.userIpCnt + ", policyCnt=" + this.policyCnt + ", whitelistCnt=" + this.whitelistCnt + ", freeTimeCnt=" + this.freeTimeCnt + ", trialFlag=" + this.trialFlag + ", ctime=" + this.ctime + '}';
    }
}

