/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.WhitelistData;
import nxd.l.m;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.p;

public class WhitelistKeywordDao
extends FirstDao {
    public void addKw(String string) {
        if (this.searchOption.size() > 0) {
            return;
        }
        this.searchOption.addKw("keyword", string, 2);
        this.searchOption.addKw("description", string, 2);
    }

    private String a() {
        String string = this.searchOption.toSql(12);
        if (nxd.lib.c.a(string)) {
            return "";
        }
        return " where " + string;
    }

    public int selectCount() {
        String string = this.a();
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from whitelist_kw" + string);
        b2.close();
        return n2;
    }

    public boolean delete(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "delete from whitelist_kw where id = ?";
        boolean bl = b2.d(string, new Object[]{n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        if (!DaoUtil.deleteOrphan()) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("whitelist_kw");
        return true;
    }

    private WhitelistData a(RowSet rowSet) {
        WhitelistData whitelistData = new WhitelistData();
        whitelistData.id = rowSet.getInt("id");
        whitelistData.keyword = rowSet.getString("keyword");
        whitelistData.description = rowSet.getString("description");
        whitelistData.bypassAuth = nxd.lib.c.c((Object)rowSet.getString("bypass_auth"));
        whitelistData.bypassFilter = nxd.lib.c.c((Object)rowSet.getString("bypass_filter"));
        whitelistData.bypassLog = nxd.lib.c.c((Object)rowSet.getString("bypass_log"));
        whitelistData.adminBlock = nxd.lib.c.c((Object)rowSet.getString("admin_block"));
        whitelistData.dropPacket = nxd.lib.c.c((Object)rowSet.getString("drop_packet"));
        return whitelistData;
    }

    public List<WhitelistData> selectList() {
        String string = this.a();
        int n2 = nxd.lib.c.a(this.limit, this.page);
        ArrayList<WhitelistData> arrayList = new ArrayList<WhitelistData>();
        String string2 = "select * from whitelist_kw" + string;
        string2 = string2 + String.format(" order by lower(keyword), id limit %s, %s", n2, this.limit);
        try (b b2 = DaoUtil.getDbConfig();
             RowSet rowSet = b2.l(string2);){
            while (rowSet.next()) {
                arrayList.add(this.a(rowSet));
            }
        }
        return arrayList;
    }

    private boolean a(WhitelistData whitelistData) {
        if (nxd.lib.c.a(whitelistData.keyword) || whitelistData.keyword.matches(".*\\s+.*")) {
            this.d.error("WKDcP, Invalid keyword!");
            return false;
        }
        if (ParamTest.isDupWhitelistKeyword(whitelistData.keyword)) {
            this.d.error("WhitelistKeywordDao, Duplicated keyword!");
            return false;
        }
        return true;
    }

    public boolean insert(WhitelistData whitelistData) {
        whitelistData.sanitize();
        if (!this.a(whitelistData)) {
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "insert into whitelist_kw(keyword, description, bypass_auth, bypass_filter, bypass_log, admin_block, drop_packet) values(?, ?, ?, ?, ?, ?, ?)";
            b2.b(string, new Object[]{whitelistData.keyword, whitelistData.description, nxd.lib.c.d(whitelistData.bypassAuth), nxd.lib.c.d(whitelistData.bypassFilter), nxd.lib.c.d(whitelistData.bypassLog), nxd.lib.c.d(whitelistData.adminBlock), nxd.lib.c.d(whitelistData.dropPacket)});
        }
        if (!DaoUtil.deleteOrphan()) {
            this.d.error("WhitelistKeywordDao.insert, DB error!");
            return false;
        }
        this.c.b("whitelist_kw");
        return true;
    }

    public WhitelistData selectOne(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from whitelist_kw where id = ?";
        RowSet rowSet = b2.m(string, new Object[]{n2});
        if (rowSet == null) {
            b2.close();
            return null;
        }
        WhitelistData whitelistData = this.a(rowSet);
        rowSet.close();
        b2.close();
        return whitelistData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(WhitelistData whitelistData) {
        whitelistData.sanitize();
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "update whitelist_kw set description = ?, bypass_auth = ?, bypass_filter = ?, bypass_log = ?, admin_block = ?, drop_packet = ? where id = ?";
            b2.c(string, new Object[]{whitelistData.description, nxd.lib.c.d(whitelistData.bypassAuth), nxd.lib.c.d(whitelistData.bypassFilter), nxd.lib.c.d(whitelistData.bypassLog), nxd.lib.c.d(whitelistData.adminBlock), nxd.lib.c.d(whitelistData.dropPacket), whitelistData.id});
        }
        this.c.b("whitelist_kw");
        return true;
    }

    public boolean writeCsvFile(String string) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(new Object[]{"Keyword", "Description", "Bypass-Auth", "Bypass-Filter", "Bypass-Log", "Adming Block", "Drop Packet", "Applied Policies"});
        List<WhitelistData> list = this.selectList();
        for (WhitelistData whitelistData : list) {
            Object[] objectArray = new Object[9];
            objectArray[0] = whitelistData.keyword;
            objectArray[1] = whitelistData.description;
            objectArray[2] = nxd.lib.c.d(whitelistData.bypassAuth);
            objectArray[3] = nxd.lib.c.d(whitelistData.bypassFilter);
            objectArray[4] = nxd.lib.c.d(whitelistData.bypassLog);
            objectArray[5] = nxd.lib.c.d(whitelistData.adminBlock);
            objectArray[6] = nxd.lib.c.d(whitelistData.dropPacket);
            objectArray[7] = whitelistData.appliedPolicyMap.keySet().stream().map(String::valueOf).collect(Collectors.joining(","));
            arrayList.add(objectArray);
        }
        return m.a(p.l + "/" + string, arrayList);
    }

    public int importFile(String string) {
        int n2 = 0;
        List<Object[]> list = null;
        try {
            list = m.c(string);
        }
        catch (Exception exception) {
            this.d.info("WhitelistKeywordDao.importFile, {}", (Object)exception.toString());
        }
        if (list == null) {
            return n2;
        }
        for (Object[] objectArray : list) {
            WhitelistData whitelistData = new WhitelistData();
            whitelistData.keyword = objectArray[0].toString();
            whitelistData.description = objectArray[1].toString();
            whitelistData.bypassAuth = nxd.lib.c.c(objectArray[2]);
            whitelistData.bypassFilter = nxd.lib.c.c(objectArray[3]);
            whitelistData.bypassLog = nxd.lib.c.c(objectArray[4]);
            whitelistData.adminBlock = nxd.lib.c.c(objectArray[5]);
            whitelistData.dropPacket = nxd.lib.c.c(objectArray[6]);
            whitelistData.appliedPolicyArr = objectArray[7].toString().split(",");
            if (!this.insert(whitelistData)) continue;
            ++n2;
        }
        if (n2 > 0) {
            this.d.info("WhitelistKeywordDao.importFile, Added data = {}", (Object)n2);
        }
        return n2;
    }
}

